/*
 * Decompiled with CFR 0.152.
 */
package com.jz.website.cache.ram;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.website.tables.pojos.NewsTopic;
import com.jz.website.service.NewsTopicService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class NewsTopicRAMCache {
    @Autowired
    private NewsTopicService newsTopicService;
    private static Map<Integer, NewsTopic> id2Topic = Maps.newHashMap();
    private static Map<Integer, List<Integer>> parent2Children = Maps.newLinkedHashMap();
    private static Set<Integer> roots = Sets.newHashSet();
    public static final Integer newsTopic = 10001;
    public static final Integer studyTopic = 10000;
    public static final Integer ppdt = 10002;
    public static final Integer xqjs = 10003;
    public static final Integer tzrfc = 10004;

    @PostConstruct
    public void loadTopic2Cache() {
        List<NewsTopic> topics = this.newsTopicService.findAll();
        if (ArrayMapTools.isEmpty(topics)) {
            return;
        }
        topics.forEach(it -> {
            id2Topic.put(it.getId(), (NewsTopic)it);
            if (null == it.getParent()) {
                roots.add(it.getId());
            } else {
                if (!parent2Children.containsKey(it.getParent())) {
                    parent2Children.put(it.getParent(), Lists.newArrayList());
                }
                parent2Children.get(it.getParent()).add(it.getId());
            }
        });
    }

    public static boolean isRoot(Integer tid) {
        return null != tid && roots.contains(tid);
    }

    public static boolean isValid(Integer tid) {
        return null != tid && id2Topic.containsKey(tid);
    }

    public static List<NewsTopic> getChildren(Integer tid) {
        if (null == tid || !parent2Children.containsKey(tid)) {
            return null;
        }
        return parent2Children.get(tid).stream().map(id2Topic::get).collect(Collectors.toList());
    }

    public static NewsTopic getTopic(Integer tid) {
        if (null == tid || !id2Topic.containsKey(tid)) {
            return null;
        }
        return id2Topic.get(tid);
    }
}

