package com.jz.oss.jar.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oss.Tables;
import com.jz.jooq.oss.tables.pojos.SmsVerificationCode;
import com.jz.jooq.oss.tables.records.SmsVerificationCodeRecord;

@Lazy
@Repository
public class SmsVerificationCodeRepository extends OssBaseRepository {

	private static final com.jz.jooq.oss.tables.SmsVerificationCode SVC = Tables.SMS_VERIFICATION_CODE;

	public void save(SmsVerificationCodeRecord record) {
		ossCtx.insertInto(SVC).set(record).execute();
	}

	public SmsVerificationCode getValidCode(String phone, String app, String model, long timeMillis) {
		Condition condition = SVC.PHONE.eq(phone).and(SVC.EXPIRY.ge(timeMillis)).and(SVC.APP.eq(app));
		if (StringTools.isNotEmptyAndBlank(model))
			condition = condition.and(SVC.MODEL.eq(model));
		List<SmsVerificationCode> codes = ossCtx.selectFrom(SVC).where(condition).orderBy(SVC.CREATE_TIME.desc())
				.fetchInto(SmsVerificationCode.class);
		return ArrayMapTools.isNotEmpty(codes) ? codes.get(0) : null;
	}

	public void updateLastSend(Integer id) {
		ossCtx.update(SVC).set(SVC.LAST_SEND, System.currentTimeMillis()).where(SVC.ID.eq(id)).execute();
	}
}
