/*
 * Decompiled with CFR 0.152.
 */
package com.jz.odps.mr;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.TableInfo;
import com.aliyun.odps.mapred.JobClient;
import com.aliyun.odps.mapred.Mapper;
import com.aliyun.odps.mapred.MapperBase;
import com.aliyun.odps.mapred.Reducer;
import com.aliyun.odps.mapred.ReducerBase;
import com.aliyun.odps.mapred.conf.JobConf;
import com.aliyun.odps.mapred.utils.InputUtils;
import com.aliyun.odps.mapred.utils.OutputUtils;
import com.aliyun.odps.mapred.utils.SchemaUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public class ParseOdps {
    public static void main(String[] args) throws Exception {
        String taskTime = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (args.length > 0) {
            taskTime = args[0];
            try {
                taskTime = df.format(DateUtils.parseDate((String)taskTime, (String[])new String[]{"yyyy-MM-dd", "yyyyMMdd"}));
            }
            catch (ParseException e) {
                throw new RuntimeException("\u8bf7\u8f93\u5165\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\u4e3a yyyy-MM-dd \u683c\u5f0f\u7684\u65e5\u671f");
            }
        } else {
            taskTime = df.format(DateUtils.addDays((Date)new Date(), (int)-1));
        }
        System.out.println("taskTime:" + taskTime);
        JobConf job = new JobConf();
        job.setMapperClass(MyMapper.class);
        job.setReducerClass(MyReducer.class);
        job.setMapOutputKeySchema(SchemaUtils.fromString((String)"iden:string"));
        job.setMapOutputValueSchema(SchemaUtils.fromString((String)"type:string,server_time:string,sid:string,uid:string,app:string,data:string"));
        InputUtils.addTable((TableInfo)TableInfo.builder().tableName("app_log").partSpec(ParseOdps.convertPartSpecToMap(taskTime)).build(), (JobConf)job);
        Map<String, List<String>> eventMap = ParseOdps.initEventMap();
        for (String table : eventMap.keySet()) {
            OutputUtils.addTable((TableInfo)TableInfo.builder().tableName(table).partSpec(ParseOdps.convertPartSpecToMap(taskTime)).label(table).build(), (JobConf)job);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : eventMap.entrySet()) {
            sb.append(entry.getKey()).append("||").append(StringUtils.join((Collection)entry.getValue(), (String)"$")).append(";");
        }
        String eventMapStr = sb.toString();
        System.out.println(eventMapStr);
        job.set("eventMapStr", eventMapStr);
        JobClient.runJob((JobConf)job);
    }

    public static LinkedHashMap<String, String> convertPartSpecToMap(String taskTime) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("ctime", taskTime);
        return map;
    }

    public static Map<String, List<String>> initEventMap() {
        HashMap<String, List<String>> eventMap = new HashMap<String, List<String>>();
        String driver = "com.mysql.jdbc.Driver";
        String url = "jdbc:mysql://rm-2zeh0uf0fj0o8m9iw.mysql.rds.aliyuncs.com:3306/franchise_tongji?autoReconnect=true&useUnicode=true&characterEncoding=utf8&noAccessToProcedureBodies=true";
        String user = "jz_franchise";
        String password = "franchise_12987";
        ResultSet rs = null;
        Connection conn = null;
        try {
            try {
                Class.forName(driver);
                conn = DriverManager.getConnection(url, user, password);
                if (!conn.isClosed()) {
                    System.out.println("Succeeded connecting to the Database!");
                }
                Statement statement = conn.createStatement();
                String sql = "SELECT `type`,`key_name` FROM `log_setting` ORDER BY id ASC";
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String type = rs.getString("type");
                    String key_name = StringUtils.lowerCase((String)rs.getString("key_name"));
                    if (eventMap.get(type) == null) {
                        ArrayList<String> keyList = new ArrayList<String>();
                        keyList.add(key_name);
                        eventMap.put(type, keyList);
                        continue;
                    }
                    ((List)eventMap.get(type)).add(key_name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return eventMap;
    }

    public static class MyMapper
    extends MapperBase {
        Record iden;
        Record content;

        public void setup(Mapper.TaskContext context) throws IOException {
            this.iden = context.createMapOutputKeyRecord();
            this.content = context.createMapOutputValueRecord();
        }

        public void map(long recordNum, Record record, Mapper.TaskContext context) throws IOException {
            this.content = record;
            if (record.getColumnCount() != 6) {
                this.iden.set(new Object[]{"error"});
            } else {
                String type = record.getString(0);
                String sid = record.getString(2);
                String app = record.getString(4);
                String data = record.getString(5);
                String ts = "0";
                String table = type;
                if ("body".equals(type) || "header".equals(type)) {
                    String[] stringArray = StringUtils.splitPreserveAllTokens((String)data, (String)",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        String[] arr = StringUtils.splitPreserveAllTokens((String)item, (String)":");
                        if (arr.length == 2) {
                            if ("body".equals(type) && StringUtils.equals((String)arr[0], (String)"t")) {
                                table = String.valueOf(table) + "_" + arr[1];
                            }
                            if (StringUtils.equals((String)arr[0], (String)"ts")) {
                                ts = arr[1];
                            }
                            if (!StringUtils.equals((String)"body", (String)table) && !StringUtils.equals((String)"0", (String)ts)) break;
                        }
                        ++n2;
                    }
                    table = String.valueOf(table) + "||" + sid + "_" + app + "_" + "_" + ts;
                }
                this.iden.set(new Object[]{table});
            }
            context.write(this.iden, this.content);
        }
    }

    public static class MyReducer
    extends ReducerBase {
        private Map<String, List<String>> eventMap = null;
        private Map<String, Record> recordMap = null;

        public void setup(Reducer.TaskContext context) throws IOException {
            String[] items;
            this.eventMap = new HashMap<String, List<String>>();
            this.recordMap = new HashMap<String, Record>();
            String eventMapStr = context.getJobConf().get("eventMapStr");
            String[] stringArray = items = StringUtils.split((String)eventMapStr, (String)";");
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                String[] kv = StringUtils.splitByWholeSeparator((String)item, (String)"||");
                if (kv.length == 2) {
                    this.eventMap.put(kv[0], Arrays.asList(StringUtils.split((String)kv[1], (String)"$")));
                    this.recordMap.put(kv[0], context.createOutputRecord(kv[0]));
                }
                ++n2;
            }
        }

        /*
         * Unable to fully structure code
         */
        public void reduce(Record keyRecord, Iterator<Record> values, Reducer.TaskContext context) throws IOException {
            key = keyRecord.getString(0);
            if (StringUtils.isNotEmpty((String)key)) {
                key = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)key, (String)"||")[0];
            }
            if (!this.eventMap.containsKey(key)) {
                return;
            }
            nameList = this.eventMap.get(key);
            if (nameList == null) {
                return;
            }
            result = this.recordMap.get(key);
            if (result != null) ** GOTO lbl50
            return;
lbl-1000:
            // 1 sources

            {
                line = values.next();
                dataSeparator = ",";
                if (line.getColumnCount() != 6) {
                    System.out.println("errorLine:" + line.toString());
                    continue;
                }
                if (line.get(4) == null) {
                    System.out.println("errorLine:" + line.toString());
                    continue;
                }
                result.set(0, line.get(1));
                result.set(1, line.get(2));
                result.set(2, line.get(3));
                result.set(3, (Object)StringUtils.lowerCase((String)line.get(4).toString()));
                data = line.getString(5);
                lineMap = new HashMap<String, String>();
                var14_17 = StringUtils.splitPreserveAllTokens((String)data, (String)dataSeparator);
                var13_16 = var14_17.length;
                var12_13 = 0;
                while (var12_13 < var13_16) {
                    item = var14_17[var12_13];
                    kv = StringUtils.splitPreserveAllTokens((String)item, (String)":");
                    if (kv.length == 2) {
                        lineMap.put(StringUtils.lowerCase((String)kv[0]), kv[1]);
                    }
                    ++var12_13;
                }
                i = 4;
                for (String name : nameList) {
                    value = (String)lineMap.get(name);
                    if (StringUtils.equals((String)"platform", (String)name) && value == null) {
                        value = "android";
                    }
                    if (value == null) {
                        value = "";
                    }
                    if (i >= result.getColumnCount()) break;
                    result.set(i, (Object)value);
                    ++i;
                }
                context.write(result, key);
                if (StringUtils.startsWith((String)key, (String)"body") || StringUtils.equals((String)key, (String)"header")) break;
lbl50:
                // 4 sources

                ** while (values.hasNext())
            }
lbl51:
            // 2 sources

        }
    }
}

