/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksTheme;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksThemeRepository
extends MediaBaseRepository {
    private static final WorksTheme WT = Tables.WORKS_THEME;

    private Condition getOnlineCondition() {
        return WorksThemeRepository.WT.STATUS.eq((Object)SourceStatus.online.getCode()).and(WorksThemeRepository.WT.WORKS_CNT.gt((Object)0));
    }

    public int countOnlineWorksTheme() {
        return this.mediaCtx.fetchCount((Table)WT, this.getOnlineCondition());
    }

    public List<String> getOnlineWorksThemeIds(int start, int size) {
        return this.mediaCtx.select((SelectField)WorksThemeRepository.WT.ID).from((TableLike)WT).where(new Condition[]{this.getOnlineCondition()}).orderBy(WorksThemeRepository.WT.SEQ.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksTheme> findWorksThemeInfo(Collection<String> ids) {
        return this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksThemeRepository.WT.ID.in(ids)}).orderBy(WorksThemeRepository.WT.SEQ.desc()).fetchInto(com.jz.jooq.media.tables.pojos.WorksTheme.class);
    }

    public void addWorksCnt(Collection<String> ids, int cnt) {
        this.mediaCtx.update((Table)WT).set((Field)WorksThemeRepository.WT.WORKS_CNT, WorksThemeRepository.WT.WORKS_CNT.add((Number)cnt)).where(new Condition[]{WorksThemeRepository.WT.ID.in(ids)}).execute();
    }
}

