package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TestsMultipleOptionScore;
import com.jz.jooq.media.tables.pojos.TestsOption;
import com.jz.jooq.media.tables.pojos.TestsPluses;
import com.jz.jooq.media.tables.pojos.TestsQuestion;

@Lazy
@Repository
public class TestsRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TestsQuestion QUESTION = Tables.TESTS_QUESTION;
	private static final com.jz.jooq.media.tables.TestsOption OPTION = Tables.TESTS_OPTION;
	private static final com.jz.jooq.media.tables.TestsPluses PLUS = Tables.TESTS_PLUSES;
	private static final com.jz.jooq.media.tables.TestsMultipleOptionScore MULTIPLE = Tables.TESTS_MULTIPLE_OPTION_SCORE;
	private static final com.jz.jooq.media.tables.TestsScores SCORES = Tables.TESTS_SCORES;

	public List<TestsQuestion> getOnlineQuestion(String crowd) {
		return mediaCtx.selectFrom(QUESTION)
				.where(QUESTION.CROWD.eq(crowd).and(QUESTION.STATUS.eq(SourceStatus.online.getCode())))
				.orderBy(QUESTION.SEQ.asc()).fetchInto(TestsQuestion.class);
	}

	public List<TestsOption> getOptions(Collection<String> questionIds) {
		return mediaCtx.selectFrom(OPTION).where(OPTION.QID.in(questionIds)).orderBy(OPTION.SEQ.asc())
				.fetchInto(TestsOption.class);
	}

	public List<TestsPluses> getPluses(Collection<String> questionIds, int age) {
		return mediaCtx.selectFrom(PLUS)
				.where(PLUS.QID.in(questionIds).and(PLUS.MAX_AGE.ge(age)).and(PLUS.MIN_AGE.le(age)))
				.fetchInto(TestsPluses.class);
	}

	public List<TestsMultipleOptionScore> getMultipleScore(Collection<String> questionIds) {
		return mediaCtx.selectFrom(MULTIPLE).where(MULTIPLE.QID.in(questionIds))
				.fetchInto(TestsMultipleOptionScore.class);
	}

	public boolean existScore(String uid, String suid, String crowd) {
		return mediaCtx.fetchExists(SCORES, SCORES.UID.eq(uid).and(SCORES.SUID.eq(suid)).and(SCORES.CROWD.eq(crowd)));
	}

	public void refreshScore(String uid, String suid, String crowd,
			List<Triple<String, Integer, String>> direction2Score2Content) {
		long timeMillis = System.currentTimeMillis();
		StringBuffer sb = new StringBuffer();
		sb.append("INSERT INTO `tests_scores` ");
		sb.append("(`uid`, `suid` ,`crowd`, `direction` ,`score` ,`content` ,`create_time` )");
		sb.append("VALUES (?, ?, ?, ?, ?, ?, ?)");
		sb.append("ON DUPLICATE KEY UPDATE `score` = ?, `content` = ?, `create_time` = ?");
		List<Object[]> batchArgs = Lists.newArrayList();
		for (Triple<String, Integer, String> triple : direction2Score2Content) {
			batchArgs.add(new Object[] { uid, suid, crowd, triple.getLeft(), triple.getMiddle(), triple.getRight(),
					timeMillis, triple.getMiddle(), triple.getRight(), timeMillis });
		}
		mediaJdbcTemplate.batchUpdate(sb.toString(), batchArgs);
	}
}
