/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.StudentPlayMonthTagTotal;
import com.jz.jooq.media.tables.StudentPlayMonthTotal;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentPlayMonthTotalRepository
extends MediaBaseRepository {
    private static final StudentPlayMonthTotal MONTH = Tables.STUDENT_PLAY_MONTH_TOTAL;
    private static final StudentPlayMonthTagTotal TAG = Tables.STUDENT_PLAY_MONTH_TAG_TOTAL;

    public void refreshPlayTotal(BrandEnum brand, String suid, String month, int playLength, int videoCnt) {
        long timeMillis = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)MONTH, (Field)StudentPlayMonthTotalRepository.MONTH.BRAND, (Field)StudentPlayMonthTotalRepository.MONTH.SUID, (Field)StudentPlayMonthTotalRepository.MONTH.MONTH, (Field)StudentPlayMonthTotalRepository.MONTH.PLAY_TIME, (Field)StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT, (Field)StudentPlayMonthTotalRepository.MONTH.CREATE_TIME, (Field)StudentPlayMonthTotalRepository.MONTH.LAST_UPDATE).values((Object)brand.name(), (Object)suid, (Object)month, (Object)playLength, (Object)videoCnt, (Object)timeMillis, (Object)timeMillis).onDuplicateKeyUpdate().set((Field)StudentPlayMonthTotalRepository.MONTH.PLAY_TIME, StudentPlayMonthTotalRepository.MONTH.PLAY_TIME.add((Number)playLength)).set((Field)StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT, StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT.add((Number)videoCnt)).set((Field)StudentPlayMonthTotalRepository.MONTH.LAST_UPDATE, (Object)timeMillis).execute();
    }

    public void refreshTagPlayTotal(BrandEnum brand, String suid, String month, List<String> tags, int playLength, int videoCnt) {
        long timeMillis = System.currentTimeMillis();
        ArrayList sqls = Lists.newArrayList();
        for (String tag : tags) {
            sqls.add(this.mediaCtx.insertInto((Table)TAG, (Field)StudentPlayMonthTotalRepository.TAG.BRAND, (Field)StudentPlayMonthTotalRepository.TAG.SUID, (Field)StudentPlayMonthTotalRepository.TAG.TAG, (Field)StudentPlayMonthTotalRepository.TAG.MONTH, (Field)StudentPlayMonthTotalRepository.TAG.PLAY_TIME, (Field)StudentPlayMonthTotalRepository.TAG.VIDEO_CNT, (Field)StudentPlayMonthTotalRepository.TAG.CREATE_TIME, (Field)StudentPlayMonthTotalRepository.TAG.LAST_UPDATE).values((Object)brand.name(), (Object)suid, (Object)tag, (Object)month, (Object)playLength, (Object)videoCnt, (Object)timeMillis, (Object)timeMillis).onDuplicateKeyUpdate().set((Field)StudentPlayMonthTotalRepository.MONTH.PLAY_TIME, StudentPlayMonthTotalRepository.MONTH.PLAY_TIME.add((Number)playLength)).set((Field)StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT, StudentPlayMonthTotalRepository.MONTH.VIDEO_CNT.add((Number)videoCnt)).set((Field)StudentPlayMonthTotalRepository.MONTH.LAST_UPDATE, (Object)timeMillis).getSQL());
        }
        String[] array = new String[]{};
        this.mediaCtx.batch(sqls.toArray(array)).execute();
    }
}

