package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.FansRelationRepository;

@Lazy
@Service
public class FansRelationService {

	@Autowired
	private FansRelationRepository fansRelationRepository;

	public void addFansRelation(BrandEnum brand, String puid, String fuid) {
		fansRelationRepository.addFansRelation(brand, puid, fuid);
	}

	public void deleteMyFollow(BrandEnum brand, String puid, String fuid) {
		fansRelationRepository.deleteMyFollow(brand, puid, fuid);
	}

	public int countMyFans(BrandEnum brand, String puid) {
		return fansRelationRepository.countMyFans(brand, puid);
	}

	public List<String> getMyFans(BrandEnum brand, String puid, int start, int size) {
		return fansRelationRepository.getMyFans(brand, puid, start, size);
	}

	public int countMyFollow(BrandEnum brand, String fuid) {
		return fansRelationRepository.countMyFollow(brand, fuid);
	}

	public List<String> getMyFollow(BrandEnum brand, String fuid) {
		return fansRelationRepository.getMyFollow(brand, fuid);
	}

	public List<String> getMyFollow(BrandEnum brand, String fuid, int start, int size) {
		return fansRelationRepository.getMyFollow(brand, fuid, start, size);
	}

	/** 获取关系数量 result -> k : 粉丝数, v 关注数 */
	public Pair<Integer, Integer> getRelationCnt(BrandEnum brand, String uid) {
		return fansRelationRepository.getRelationCnt(brand, uid);
	}

	/** 筛选出已关注的 */
	public List<String> screenMyFollow(BrandEnum brand, String fuid, Collection<String> puids) {
		return fansRelationRepository.screenMyFollow(brand, fuid, puids);
	}
}
