package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.ReadType;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserRead;

@Lazy
@Repository
public class UserReadRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserRead UR = Tables.USER_READ;

	public void refreshReadTime(String uid, BrandEnum brand, ReadType type) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(UR, UR.UID, UR.BRAND, UR.TYPE, UR.READ_TIME)
				.values(uid, brand.name(), type.name(), timeMillis).onDuplicateKeyUpdate().set(UR.READ_TIME, timeMillis)
				.execute();
	}

	public List<UserRead> getReadTimes(String uid, BrandEnum brand) {
		return mediaCtx.selectFrom(UR).where(UR.UID.eq(uid).and(UR.BRAND.eq(brand.name()))).fetchInto(UserRead.class);
	}

	public Long getReadTime(String uid, BrandEnum brand, ReadType type) {
		return mediaCtx.select(UR.READ_TIME).from(UR)
				.where(UR.UID.eq(uid).and(UR.BRAND.eq(brand.name())).and(UR.TYPE.eq(type.name())))
				.fetchAnyInto(Long.class);
	}

}
