/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.repository.BaseConditionRepository;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.ArtThemeRelation;
import com.jz.jooq.media.tables.pojos.ArtInfo;
import com.jz.jooq.media.tables.records.ArtInfoRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ArtInfoRepository
extends MediaBaseRepository
implements BaseConditionRepository<ArtInfoRecord> {
    private static final com.jz.jooq.media.tables.ArtInfo AI = Tables.ART_INFO;
    private static final ArtThemeRelation ATR = Tables.ART_THEME_RELATION;

    public boolean existArtInfo(String id, BrandEnum brand) {
        return this.mediaCtx.fetchExists((Table)AI, ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name())));
    }

    public ArtInfo getArtInfo(String id, BrandEnum brand) {
        return (ArtInfo)this.mediaCtx.selectFrom((Table)AI).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(ArtInfo.class);
    }

    public ArtInfo getSimpleArtInfo(String id, BrandEnum brand) {
        return (ArtInfo)this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID, (SelectField)ArtInfoRepository.AI.SCHOOL_ID, (SelectField)ArtInfoRepository.AI.LESSON_ID, (SelectField)ArtInfoRepository.AI.PUID, (SelectField)ArtInfoRepository.AI.SUID, (SelectField)ArtInfoRepository.AI.IS_OPEN).from((TableLike)AI).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(ArtInfo.class);
    }

    public void updateOpenInfo(String id, BrandEnum brand, int isOpen) {
        this.mediaCtx.update((Table)AI).set((Field)ArtInfoRepository.AI.IS_OPEN, (Object)isOpen).set((Field)ArtInfoRepository.AI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{ArtInfoRepository.AI.ID.eq((Object)id).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name()))}).execute();
    }

    private Condition getCondition(BrandEnum brand, Collection<String> uids) {
        return ArtInfoRepository.AI.BRAND.eq((Object)brand.name()).and(ArtInfoRepository.AI.PUID.in(uids)).and(ArtInfoRepository.AI.IS_OPEN.ge((Object)1)).and(ArtInfoRepository.AI.STATUS.eq((Object)SourceStatus.online.getCode()));
    }

    public int countOpenNewArt(BrandEnum brand, Collection<String> uids, long timestamp) {
        return this.mediaCtx.fetchCount((Table)AI, this.getCondition(brand, uids).and(ArtInfoRepository.AI.CREATE_TIME.gt((Object)timestamp)));
    }

    public int countOpenArt(BrandEnum brand, Collection<String> uids) {
        return this.mediaCtx.fetchCount((Table)AI, this.getCondition(brand, uids));
    }

    public List<String> findOpenArtIds(BrandEnum brand, Collection<String> uids, int start, int size) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID).from((TableLike)AI).where(new Condition[]{this.getCondition(brand, uids)}).orderBy(ArtInfoRepository.AI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<ArtInfo> findSimpleArtInfo(Collection<String> artIds) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID, (SelectField)ArtInfoRepository.AI.PUID, (SelectField)ArtInfoRepository.AI.RESOURCE).from((TableLike)AI).where(new Condition[]{ArtInfoRepository.AI.ID.in(artIds)}).fetchInto(ArtInfo.class);
    }

    private Condition getRecommonCondition(BrandEnum brand) {
        return ArtInfoRepository.AI.BRAND.eq((Object)brand.name()).and(ArtInfoRepository.AI.IS_OPEN.ge((Object)1)).and(ArtInfoRepository.AI.STATUS.eq((Object)SourceStatus.online.getCode()));
    }

    public int countRecommonArts(BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)AI, this.getRecommonCondition(brand));
    }

    public List<String> findRecommonArtIds(BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.ID).from((TableLike)AI).where(new Condition[]{this.getRecommonCondition(brand)}).orderBy(ArtInfoRepository.AI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<ArtInfo> findExistArtInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
        Condition condition = this.getOrWhereCondition(ArtInfoRepository.AI.SCHOOL_ID, ArtInfoRepository.AI.LESSON_ID, school2LessonIds);
        return this.mediaCtx.select((SelectField)ArtInfoRepository.AI.SCHOOL_ID, (SelectField)ArtInfoRepository.AI.LESSON_ID, (SelectField)ArtInfoRepository.AI.ID).from((TableLike)AI).where(new Condition[]{condition.and(ArtInfoRepository.AI.SUID.eq((Object)suid))}).fetchInto(ArtInfo.class);
    }

    private TableOnConditionStep getJoinTable() {
        return ATR.join((TableLike)AI).on(new Condition[]{ArtInfoRepository.ATR.ART_ID.eq((Field)ArtInfoRepository.AI.ID)});
    }

    private Condition getRelationCondition(BrandEnum brand, String themeId) {
        return ArtInfoRepository.ATR.THEME_ID.eq((Object)themeId).and(ArtInfoRepository.AI.BRAND.eq((Object)brand.name())).and(ArtInfoRepository.AI.IS_OPEN.ge((Object)1)).and(ArtInfoRepository.AI.STATUS.eq((Object)SourceStatus.online.getCode()));
    }

    public int countArts(BrandEnum brand, String themeId) {
        return this.mediaCtx.fetchCount((Table)this.getJoinTable(), this.getRelationCondition(brand, themeId));
    }

    public List<String> getArtIds(BrandEnum brand, String themeId, boolean isHot, int start, int size) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.ATR.ART_ID).from((TableLike)this.getJoinTable()).where(new Condition[]{this.getRelationCondition(brand, themeId)}).orderBy(new SortField[]{isHot ? ArtInfoRepository.ATR.LIKE_CNT.desc() : ArtInfoRepository.ATR.UPLOAD_TIME.desc()}).limit(start, size).fetchInto(String.class);
    }

    public List<String> getAllThemeIds(String artId) {
        return this.mediaCtx.select((SelectField)ArtInfoRepository.ATR.THEME_ID).from((TableLike)ATR).where(new Condition[]{ArtInfoRepository.ATR.ART_ID.eq((Object)artId)}).fetchInto(String.class);
    }

    public void addLikeCnt(String artId, int cnt) {
        this.mediaCtx.update((Table)ATR).set((Field)ArtInfoRepository.ATR.LIKE_CNT, ArtInfoRepository.ATR.LIKE_CNT.add((Number)cnt)).where(new Condition[]{ArtInfoRepository.ATR.ART_ID.eq((Object)artId)}).execute();
    }
}

