package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.SourceStatus;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.ArtTheme;

@Lazy
@Repository
public class ArtThemeRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.ArtTheme AT = Tables.ART_THEME;

	private Condition getOnlineCondition() {
		return AT.STATUS.eq(SourceStatus.online.getCode()).and(AT.ART_CNT.gt(0));
	}

	public int countOnlineArtTheme() {
		return mediaCtx.fetchCount(AT, getOnlineCondition());
	}

	public List<String> getOnlineArtThemeIds(int start, int size) {
		return mediaCtx.select(AT.ID).from(AT).where(getOnlineCondition()).orderBy(AT.SEQ.desc()).limit(start, size)
				.fetchInto(String.class);
	}

	public List<ArtTheme> findArtThemeInfo(Collection<String> ids) {
		return mediaCtx.selectFrom(AT).where(AT.ID.in(ids)).orderBy(AT.SEQ.desc()).fetchInto(ArtTheme.class);
	}

	public void addArtCnt(Collection<String> ids, int cnt) {
		mediaCtx.update(AT).set(AT.ART_CNT, AT.ART_CNT.add(cnt)).where(AT.ID.in(ids)).execute();
	}
}
