/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.records.MediaVideoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class MediaVideoRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.MediaVideo VIDEO = Tables.MEDIA_VIDEO;

    public MediaVideo getVideo(String wid, BrandEnum brand) {
        return (MediaVideo)this.mediaCtx.selectFrom((Table)VIDEO).where(new Condition[]{MediaVideoRepository.VIDEO.WID.eq((Object)wid).and(MediaVideoRepository.VIDEO.BRAND.eq((Object)brand.name()))}).fetchAnyInto(MediaVideo.class);
    }

    public List<MediaVideo> findVideos(Collection<String> wids) {
        return this.mediaCtx.selectFrom((Table)VIDEO).where(new Condition[]{MediaVideoRepository.VIDEO.WID.in(wids)}).fetchInto(MediaVideo.class);
    }

    public void saveOrUpdateVideo(MediaVideoRecord mediaVideoRecord) {
        this.mediaCtx.insertInto((Table)VIDEO).set((Record)mediaVideoRecord).onDuplicateKeyUpdate().set((Record)mediaVideoRecord).execute();
    }

    public boolean isExist(String wid, BrandEnum brand) {
        return this.mediaCtx.fetchExists((Table)VIDEO, MediaVideoRepository.VIDEO.WID.eq((Object)wid).and(MediaVideoRepository.VIDEO.BRAND.eq((Object)brand.name())));
    }
}

