package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCollectVideoRepository;
import com.jz.jooq.media.tables.pojos.UserCollectVideo;

@Lazy
@Service
public class UserCollectVideoService {

	@Autowired
	private UserCollectVideoRepository userCollectVideoRepository;

	public void addCollect(String uid, String pid, String wid) {
		userCollectVideoRepository.addCollect(uid, pid, wid);
	}

	public List<UserCollectVideo> getCollect(String uid) {
		return userCollectVideoRepository.getCollect(uid);
	}

	public int countCollect(String uid) {
		return userCollectVideoRepository.countCollect(uid);
	}

	public List<UserCollectVideo> getCollect(String uid, int start, int size) {
		return userCollectVideoRepository.getCollect(uid, start, size);
	}

	public boolean isCollect(String uid, String pid, String wid) {
		return userCollectVideoRepository.isCollect(uid, pid, wid);
	}

	public void deleteCollect(String uid, String pid, String wid) {
		userCollectVideoRepository.deleteCollect(uid, pid, wid);
	}

}
