package com.jz.jar.media.enums;

/**
 * 视频状态码
 * 
 * @Title MediaVideoStatus
 * @Package com.jz.jar.media.enums
 * @author tangjunfeng
 * @date 2018年8月20日 下午4:50:55
 * @version V1.0
 */
public enum MediaVideoStatus {

	convertCode("转码中", 20), 
	waitOnline("待上线", 30),

	waitEditor("待编辑", 0), 
	
	online("已上线", 1), 
	offline("已下线", 2),
	
	delete("删除", 99)
	;

	private int code;

	MediaVideoStatus(String desc, int code) {
		this.code = code;
	}

	public static MediaVideoStatus getForCode(Integer code) {
		if (null == code)
			return null;
		for (MediaVideoStatus it : MediaVideoStatus.values()) {
			if (it.getCode() == code)
				return it;
		}
		return null;
	}

	public int getCode() {
		return code;
	}

}
