/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.Playlist;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PlaylistRelationRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.PlaylistRelation PR = Tables.PLAYLIST_RELATION;
    private static final Playlist PL = Tables.PLAYLIST;

    public List<PlaylistRelation> findLevelTopics() {
        return this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.LID, (SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).groupBy(new GroupField[]{PlaylistRelationRepository.PR.LID, PlaylistRelationRepository.PR.CID}).fetchInto(PlaylistRelation.class);
    }

    public List<String> getTopicsForPlaylist(String pid) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.PID.eq((Object)pid)}).fetchInto(String.class);
    }

    private TableOnConditionStep getOnlinePlaylistTable() {
        return PR.join((TableLike)PL).on(new Condition[]{PlaylistRelationRepository.PR.PID.eq((Field)PlaylistRelationRepository.PL.PID)});
    }

    private Condition getOnlinePlaylistCondition(String lid, Collection<String> cidArray) {
        return PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.in(cidArray)).and(PlaylistRelationRepository.PL.STATUS.eq((Object)DbField.online.name()));
    }

    public int countPlaylistForLevelAndTopic(String lid, Collection<String> cidArray) {
        return (Integer)this.mediaCtx.select((SelectField)DSL.countDistinct((Field)PlaylistRelationRepository.PR.PID)).from((TableLike)this.getOnlinePlaylistTable()).where(new Condition[]{this.getOnlinePlaylistCondition(lid, cidArray)}).fetchAnyInto(Integer.TYPE);
    }

    public List<String> findPlaylistForLevelAndTopic(String lid, Collection<String> cidArray, int start, int size) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.PID).from((TableLike)this.getOnlinePlaylistTable()).where(new Condition[]{this.getOnlinePlaylistCondition(lid, cidArray)}).orderBy(PlaylistRelationRepository.PR.PID.asc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> findPlaylistForLevelAndTopic(String lid, String cid) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.PID).from((TableLike)this.getOnlinePlaylistTable()).where(new Condition[]{this.getOnlinePlaylistCondition(lid, Arrays.asList(cid))}).orderBy(PlaylistRelationRepository.PR.PID.asc()).fetchInto(String.class);
    }

    public List<String> getSpecialTopics(String lid) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1))}).fetchInto(String.class);
    }

    public boolean isSpecial(String lid, String pid) {
        return this.mediaCtx.fetchExists((Table)PR, PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.PID.eq((Object)pid)).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1)));
    }

    public int countSpecialPlaylist(String lid, String cid) {
        return this.mediaCtx.fetchCount((Table)PR, PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.eq((Object)cid)).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1)));
    }

    public Map<String, List<String>> findSpecialTopicToPids(String lid) {
        List relations = this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.CID, (SelectField)PlaylistRelationRepository.PR.PID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1))}).orderBy(PlaylistRelationRepository.PR.SPECIAL_TIME.asc()).fetchInto(PlaylistRelation.class);
        if (ArrayMapTools.isEmpty((Collection)relations)) {
            return null;
        }
        HashMap topicToPids = Maps.newHashMap();
        relations.forEach(it -> {
            if (!topicToPids.containsKey(it.getCid())) {
                topicToPids.put(it.getCid(), Lists.newArrayList());
            }
            ((List)topicToPids.get(it.getCid())).add(it.getPid());
        });
        return topicToPids;
    }

    public List<String> findPlaylistTopic(String lid, Collection<String> pidArray) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.PID.in(pidArray).and(PlaylistRelationRepository.PR.LID.eq((Object)lid))}).fetchInto(String.class);
    }

    public Map<String, Collection<String>> findMaxWatchCntPlaylistForCids(String lid, Collection<String> cidArray, int cnt) {
        List relations = this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.PID, (SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)this.getOnlinePlaylistTable()).where(new Condition[]{this.getOnlinePlaylistCondition(lid, cidArray)}).orderBy(PlaylistRelationRepository.PR.WATCH_CNT.desc()).fetchInto(PlaylistRelation.class);
        if (ArrayMapTools.isEmpty((Collection)relations)) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        relations.forEach(it -> {
            if (!has.containsKey(it.getCid())) {
                has.put(it.getCid(), Lists.newArrayList());
            }
            if (((Collection)has.get(it.getCid())).size() < cnt) {
                ((Collection)has.get(it.getCid())).add(it.getPid());
            }
        });
        return has;
    }

    public Map<String, String> findPlaylistTopicForPidAndLevel(String lid, Collection<String> pidArray) {
        List relations = this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.PID, (SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.PID.in(pidArray).and(PlaylistRelationRepository.PR.LID.eq((Object)lid))}).fetchInto(PlaylistRelation.class);
        if (ArrayMapTools.isEmpty((Collection)relations)) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        relations.forEach(it -> has.put(it.getPid(), it.getCid()));
        return has;
    }

    public List<PlaylistRelation> findHomeShowPlaylistForLevelAndTopics(String lid, Collection<String> cids) {
        return this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.PID, (SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.in(cids)).and(PlaylistRelationRepository.PR.HOME_SHOW.eq((Object)1))}).orderBy(PlaylistRelationRepository.PR.SEQ.asc()).fetchInto(PlaylistRelation.class);
    }
}

