package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.jar.media.repository.PlaylistVideoRepository;
import com.jz.jooq.media.tables.pojos.PlaylistVideo;

/**
 * @Title PlaylistVideoService
 * @Package com.jz.jar.media.service
 * @author tangjunfeng
 * @date 2018年8月2日 上午10:15:39
 * @version V1.0
 */
@Lazy
@Service
@TCache(keyPrefix = "playlist:wids:")
public class PlaylistVideoService {

	@Autowired
	private PlaylistVideoRepository playlistVideoRepository;

//	@TList(keyArgsIndex = 0)
	public List<String> findWids(String pid) {
		return playlistVideoRepository.findWids(pid);
	}

	public List<String> findWids(String pid, int start, int size) {
		return playlistVideoRepository.findWids(pid, start, size);
	}

	public int countWids(String pid) {
		return playlistVideoRepository.countWids(pid);
	}

	public List<PlaylistVideo> getVideos(Map<String, Collection<Integer>> pid2Times) {
		return playlistVideoRepository.getVideos(pid2Times);
	}

	public boolean isExistVideoForPlaylist(String pid, String wid) {
		return playlistVideoRepository.isExistVideoForPlaylist(pid, wid);
	}
}
