package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.common.utils.other.ConstantsTool;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.CoursewareInfo;

@Lazy
@Repository
public class CoursewareInfoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.CoursewareInfo CI = Tables.COURSEWARE_INFO;

	public List<CoursewareInfo> getCoursewareInfoForCourseAndTimes(Map<Integer, Collection<Integer>> course2LessonTimes) {
		List<Condition> conditions = Lists.newArrayList();
		for (Entry<Integer, Collection<Integer>> entry : course2LessonTimes.entrySet()) {
			conditions.add(CI.COURSE_ID.eq(entry.getKey()).and(CI.LESSON_TIME.in(entry.getValue())));
		}
		Condition condition = DSL.or(conditions).and(CI.STATUS.eq(ConstantsTool._1byte));
		return mediaCtx.selectFrom(CI).where(condition).fetchInto(CoursewareInfo.class);
	}
	
}
