package com.jz.jar.media.enums;

/**
 * 用户上传的视频状态码,(code涉及到列表排序,谨慎调整)
 * @Title UploadVideoStatus
 * @Package com.jz.jar.media.enums
 * @author tangjunfeng
 * @date 2018年8月20日 下午4:50:55
 * @version V1.0
 */
public enum UploadVideoStatus {

	online("已上线", 1),
	offline("已下线(暂无可用地方)", 10),
	
	waiting("已上传,待转码", 20), 
	verifying("转码完成,审核中", 30),
	notPassed("审核未通过", 40),
	
	delete("用户删除", 98),
	adminDelete("管理员删除", 99),
	;

	private int code;
	
	UploadVideoStatus(String desc, int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
	
	public static UploadVideoStatus ofCode(int code) {
		if (code <= 0)
			return null;
		for (UploadVideoStatus temp : UploadVideoStatus.values()) {
			if (temp.getCode() == code)
				return temp;
		}
		return null;
	}
}
