package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.MonthPlaySetting;

@Lazy
@Repository
public class MonthPlaySettingRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.MonthPlaySetting MPS = Tables.MONTH_PLAY_SETTING;

	public List<MonthPlaySetting> findSettingForLid(String lid) {
		return mediaCtx.selectFrom(MPS).where(MPS.LID.eq(lid)).fetchInto(MonthPlaySetting.class);
	}
}
