package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserPlayHistory;

@Lazy
@Repository
public class UserPlayHistoryRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserPlayHistory UPH = Tables.USER_PLAY_HISTORY;

	public void save(String uid, String pid, String wid, int playLength, String nextWid, BrandEnum brand) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(UPH, UPH.UID, UPH.PID, UPH.WID, UPH.PLAY_LENGTH, UPH.NEXT_WID, UPH.BRAND, UPH.CREATE_TIME)
				.values(uid, pid, wid, playLength, nextWid, brand.name(), timeMillis).onDuplicateKeyUpdate()
				.set(UPH.WID, wid).set(UPH.PLAY_LENGTH, playLength).set(UPH.NEXT_WID, nextWid)
				.set(UPH.CREATE_TIME, timeMillis).execute();
	}

	public int countPlayHistory(String uid, BrandEnum brand) {
		return mediaCtx.fetchCount(UPH, UPH.UID.eq(uid).and(UPH.BRAND.eq(brand.name())));
	}

	public List<UserPlayHistory> getPlayHistory(String uid, BrandEnum brand, int start, int size) {
		return mediaCtx.selectFrom(UPH).where(UPH.UID.eq(uid).and(UPH.BRAND.eq(brand.name())))
				.orderBy(UPH.CREATE_TIME.desc()).limit(start, size).fetchInto(UserPlayHistory.class);
	}

	public void deleteHistory(String uid, String pid) {
		mediaCtx.deleteFrom(UPH).where(UPH.UID.eq(uid).and(UPH.PID.eq(pid))).execute();
	}

	public void deleteHistory(String uid, int cnt) {
		String sql = "DELETE FROM `media`.`user_play_history` WHERE uid = ? ORDER BY `create_time` ASC LIMIT ?";
		mediaJdbcTemplate.update(sql, uid, cnt);
	}

	public UserPlayHistory getHistory(String uid, String pid, BrandEnum brand) {
		List<UserPlayHistory> histories = mediaCtx.selectFrom(UPH)
				.where(UPH.UID.eq(uid).and(UPH.PID.eq(pid)).and(UPH.BRAND.eq(brand.name())))
				.fetchInto(UserPlayHistory.class);
		return ArrayMapTools.isNotEmpty(histories) ? histories.get(0) : null;
	}

	public List<UserPlayHistory> getHistories(String uid, Collection<String> pidArray) {
		return mediaCtx.selectFrom(UPH).where(UPH.UID.eq(uid).and(UPH.PID.in(pidArray)))
				.fetchInto(UserPlayHistory.class);
	}

	public List<String> getHistoryPids(String uid) {
		return mediaCtx.selectDistinct(UPH.PID).from(UPH).where(UPH.UID.eq(uid)).fetchInto(String.class);
	}

}
