package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoHomeDayVideo;

@Lazy
@Repository
public class TomatoHomeDayVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoHomeDayVideo THDV = Tables.TOMATO_HOME_DAY_VIDEO;

	public TomatoHomeDayVideo getTodayVideo(String date) {
		return mediaCtx.selectFrom(THDV).where(THDV.DATE.eq(date)).fetchAnyInto(TomatoHomeDayVideo.class);
	}

}
