package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackCampClass;
import com.jz.jooq.media.tables.pojos.AiPackSerie;

@Repository
public class AiRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.AiLesson AL = Tables.AI_LESSON;
	private static final com.jz.jooq.media.tables.AiLessonSection ALS = Tables.AI_LESSON_SECTION;
	private static final com.jz.jooq.media.tables.AiLessonSectionMaterial ALSM = Tables.AI_LESSON_SECTION_MATERIAL;
	private static final com.jz.jooq.media.tables.AiMaterial AM = Tables.AI_MATERIAL;
	private static final com.jz.jooq.media.tables.AiPackSerie APS = Tables.AI_PACK_SERIE;
	private static final com.jz.jooq.media.tables.AiPackCamp APC = Tables.AI_PACK_CAMP;
	private static final com.jz.jooq.media.tables.AiPackCampClass APCC = Tables.AI_PACK_CAMP_CLASS;

	public AiLesson getLesson(String aid) {
		return mediaCtx.selectFrom(AL).where(AL.AID.eq(aid)).fetchAnyInto(AiLesson.class);
	}

	public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
		return mediaCtx.selectFrom(AL).where(AL.AID.in(aids).and(AL.STATUS.eq(1))).fetchInto(AiLesson.class);
	}

	public List<AiLessonSection> getAiSections(String aid) {
		return mediaCtx.selectFrom(ALS).where(ALS.AID.eq(aid)).orderBy(ALS.SEQ.asc()).fetchInto(AiLessonSection.class);
	}

	public List<String> getAiSectionIds(String aid) {
		return mediaCtx.select(ALS.SECTION_ID).from(ALS).where(ALS.AID.eq(aid)).orderBy(ALS.SEQ.asc())
				.fetchInto(String.class);
	}

	public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
		return mediaCtx.selectFrom(ALSM).where(ALSM.AID.eq(aid)).orderBy(ALSM.SEQ.asc())
				.fetchInto(AiLessonSectionMaterial.class);
	}

	public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
		return mediaCtx.select(ALSM.MATERIAL_ID).from(ALSM).where(ALSM.AID.eq(aid).and(ALSM.SECTION_ID.eq(sectionId)))
				.orderBy(ALSM.SEQ.asc()).fetchInto(String.class);
	}

	public AiMaterial getMaterial(String id) {
		return mediaCtx.selectFrom(AM).where(AM.ID.eq(id)).fetchAnyInto(AiMaterial.class);
	}

	public List<AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
		return mediaCtx.selectFrom(AM).where(AM.ID.in(ids).and(AM.STATUS.eq(1))).fetchInto(AiMaterial.class);
	}

	public List<AiPackSerie> getSeries(String pid) {
		return mediaCtx.selectFrom(APS).where(APS.PID.eq(pid)).orderBy(APS.SEQ.asc()).fetchInto(AiPackSerie.class);
	}

	public List<AiPackCamp> getJoinAbleCampsTimeName(String pid, int size) {
		return mediaCtx.select(APC.OPEN_TIME, APC.CAMP_NAME).from(APC)
				.where(APC.PID.eq(pid).and(APC.SIGN_END_TIME.ge(System.currentTimeMillis())))
				.orderBy(APC.OPEN_TIME.asc()).limit(size).fetchInto(AiPackCamp.class);
	}

	public Long getRecentJoinAbleCamp(String pid) {
		return mediaCtx.select(APC.OPEN_TIME).from(APC)
				.where(APC.PID.eq(pid).and(APC.SIGN_END_TIME.ge(System.currentTimeMillis())))
				.orderBy(APC.OPEN_TIME.asc()).limit(1).fetchAnyInto(Long.class);
	}

	public AiPackCamp getCamp(String pid, long openTime) {
		return mediaCtx.selectFrom(APC).where(APC.PID.eq(pid).and(APC.OPEN_TIME.eq(openTime)))
				.fetchAnyInto(AiPackCamp.class);
	}

	public AiPackCampClass getRecentClass(String pid, long openTime) {
		return mediaCtx.selectFrom(APCC).where(APCC.PID.eq(pid).and(APCC.OPEN_TIME.eq(openTime)))
				.orderBy(APCC.SEQ.desc()).limit(1).fetchAnyInto(AiPackCampClass.class);
	}

	public void createCampClass(String cid, String classNo, String pid, long openTime, String campName, int seq) {
		mediaCtx.insertInto(APCC, APCC.CID, APCC.CLASS_NO, APCC.PID, APCC.OPEN_TIME, APCC.CAMP_NAME, APCC.SEQ,
				APCC.CREATE_TIME).values(cid, classNo, pid, openTime, campName, seq, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public AiPackCampClass getClassInfo(String cid) {
		return mediaCtx.selectFrom(APCC).where(APCC.CID.eq(cid)).fetchAnyInto(AiPackCampClass.class);
	}

	public AiPackCampClass getClassSimpleInfo(String cid) {
		return mediaCtx.select(APCC.CID, APCC.CLASS_NO, APCC.OPEN_TIME, APCC.CAMP_NAME).from(APCC)
				.where(APCC.CID.eq(cid)).fetchAnyInto(AiPackCampClass.class);
	}
}
