package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoAttributesRepository;
import com.jz.jooq.media.tables.pojos.TomatoAttributes;

@Lazy
@Service
public class TomatoAttributesService {

	@Autowired
	private TomatoAttributesRepository tomatoAttributesRepository;

	public TomatoAttributes getAttribute(String attrId) {
		return tomatoAttributesRepository.getAttribute(attrId);
	}

	public List<TomatoAttributes> findAttributes(Collection<String> attrIds) {
		return tomatoAttributesRepository.findAttributes(attrIds);
	}

	public List<TomatoAttributes> findAllAttributes() {
		return tomatoAttributesRepository.findAllAttributes();
	}
	
	public Map<String, TomatoAttributes> findAttributeHas(Collection<String> attrIds) {
		return tomatoAttributesRepository.findAttributeHas(attrIds);
	}
}
