package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserAiHomework;
import com.jz.jooq.media.tables.pojos.UserAiLesson;
import com.jz.jooq.media.tables.pojos.UserAiLessonSection;
import com.jz.jooq.media.tables.pojos.UserAiPack;

@Repository
public class UserAiRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserAiHomework UAH = Tables.USER_AI_HOMEWORK;
	private static final com.jz.jooq.media.tables.UserAiPack UAP = Tables.USER_AI_PACK;
	private static final com.jz.jooq.media.tables.UserAiLesson UAL = Tables.USER_AI_LESSON;
	private static final com.jz.jooq.media.tables.UserAiLessonSection UALS = Tables.USER_AI_LESSON_SECTION;

	public void saveHomeworkPic(String suid, String pid, String aid, String sectionId, String materialId, String pic) {
		mediaCtx.insertInto(UAH, UAH.SUID, UAH.PID, UAH.AID, UAH.SECTION_ID, UAH.MATERIAL_ID, UAH.PIC, UAH.CREATE_TIME)
				.values(suid, pid, aid, sectionId, materialId, pic, System.currentTimeMillis()).onDuplicateKeyUpdate()
				.set(UAH.PIC, pic).execute();
	}

	public void saveHomeworkAudio(String suid, String pid, String aid, String sectionId, String materialId, String audio) {
		mediaCtx.insertInto(UAH, UAH.SUID, UAH.PID, UAH.AID, UAH.SECTION_ID, UAH.MATERIAL_ID, UAH.AUDIO,
				UAH.CREATE_TIME).values(suid, pid, aid, sectionId, materialId, audio, System.currentTimeMillis())
				.onDuplicateKeyUpdate().set(UAH.AUDIO, audio).execute();
	}

	public List<UserAiHomework> getHomeworks(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UAH).where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid)))
				.fetchInto(UserAiHomework.class);
	}

	public List<UserAiHomework> mutiGetHomework(String suid, String pid, String aid, Collection<String> materialIds) {
		return mediaCtx
				.selectFrom(UAH)
				.where(UAH.SUID.eq(suid).and(UAH.PID.eq(pid)).and(UAH.AID.eq(aid)).and(UAH.MATERIAL_ID.in(materialIds)))
				.fetchInto(UserAiHomework.class);
	}

	public void savePack(String uid, String suid, String pid, long openTime, String cid) {
		mediaCtx.insertInto(UAP, UAP.UID, UAP.SUID, UAP.PID, UAP.OPEN_TIME, UAP.CID, UAP.CREATE_TIME)
				.values(uid, suid, pid, openTime, cid, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public UserAiPack getPack(String uid, String pid) {
		return mediaCtx.selectFrom(UAP).where(UAP.UID.eq(uid).and(UAP.PID.eq(pid))).fetchAnyInto(UserAiPack.class);
	}

	public int cntPackByCid(String cid) {
		return mediaCtx.fetchCount(UAP, UAP.CID.eq(cid));
	}

	public void saveLesson(String suid, String pid, String aid, int status, String currentSectionId,
			String currentMaterialId) {
		mediaCtx.insertInto(UAL, UAL.SUID, UAL.PID, UAL.AID, UAL.STATUS, UAL.CREATE_TIME, UAL.CURRENT_SECTION_ID,
				UAL.CURRENT_MATERIAL_ID)
				.values(suid, pid, aid, status, System.currentTimeMillis(), currentSectionId, currentMaterialId)
				.onDuplicateKeyUpdate().set(UAL.STATUS, status).set(UAL.CURRENT_SECTION_ID, currentSectionId)
				.set(UAL.CURRENT_MATERIAL_ID, currentMaterialId).execute();
	}

	public List<UserAiLesson> getLessons(String suid, String pid) {
		return mediaCtx.selectFrom(UAL).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid))).fetchInto(UserAiLesson.class);
	}

	public UserAiLesson getLesson(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UAL).where(UAL.SUID.eq(suid).and(UAL.PID.eq(pid)).and(UAL.AID.eq(aid)))
				.fetchAnyInto(UserAiLesson.class);
	}

	public void saveSection(String suid, String pid, String aid, String sectionId, int status, String currentMaterialId) {
		mediaCtx.insertInto(UALS, UALS.SUID, UALS.PID, UALS.AID, UALS.SECTION_ID, UALS.STATUS, UALS.CREATE_TIME,
				UALS.CURRENT_MATERIAL_ID)
				.values(suid, pid, aid, sectionId, status, System.currentTimeMillis(), currentMaterialId)
				.onDuplicateKeyUpdate().set(UALS.STATUS, status).set(UALS.CURRENT_MATERIAL_ID, currentMaterialId)
				.execute();
	}

	public List<UserAiLessonSection> getSections(String suid, String pid, String aid) {
		return mediaCtx.selectFrom(UALS).where(UALS.SUID.eq(suid).and(UALS.PID.eq(pid)).and(UALS.AID.eq(aid)))
				.fetchInto(UserAiLessonSection.class);
	}

	public UserAiLessonSection getSection(String suid, String pid, String aid, String sectionId) {
		return mediaCtx
				.selectFrom(UALS)
				.where(UALS.SUID.eq(suid).and(UALS.PID.eq(pid)).and(UALS.AID.eq(aid))
						.and(UALS.SECTION_ID.eq(sectionId))).fetchAnyInto(UserAiLessonSection.class);
	}
}
