package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Question;

@Lazy
@Repository
public class QuestionRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.Question QT = Tables.QUESTION;

	public List<Question> getQuestions(Collection<String> qids) {
		return mediaCtx.selectFrom(QT).where(QT.QID.in(qids)).fetchInto(Question.class);
	}
	
	public List<Question> getOnlineQuestions(Collection<String> qids) {
		return mediaCtx.selectFrom(QT).where(QT.QID.in(qids).and(QT.STATUS.eq(DbField.online.name()))).fetchInto(Question.class);
	}
}
