package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.AiRepository;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCamp;
import com.jz.jooq.media.tables.pojos.AiPackCampClass;
import com.jz.jooq.media.tables.pojos.AiPackSerie;

@Lazy
@Service
public class AiService {

	@Autowired
	private AiRepository aiRepository;

	public AiLesson getLesson(String aid) {
		return aiRepository.getLesson(aid);
	}

	public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
		return aiRepository.mutiGetOnlineLesson(aids);
	}

	public List<AiLessonSection> getAiSections(String aid) {
		return aiRepository.getAiSections(aid);
	}

	public List<String> getAiSectionIds(String aid) {
		return aiRepository.getAiSectionIds(aid);
	}

	public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
		return aiRepository.getAiMaterials(aid);
	}

	public List<String> getAiMaterialIdsInSection(String aid, String sectionId) {
		return aiRepository.getAiMaterialIdsInSection(aid, sectionId);
	}

	public AiMaterial getMaterial(String id) {
		return aiRepository.getMaterial(id);
	}

	public List<AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
		return aiRepository.mutiGetOnlineMaterials(ids);
	}

	public List<AiPackSerie> getSeries(String pid) {
		return aiRepository.getSeries(pid);
	}

	public List<AiPackCamp> getJoinAbleCampsTimeName(String pid, int size) {
		return aiRepository.getJoinAbleCampsTimeName(pid, size);
	}

	public Long getRecentJoinAbleCamp(String pid) {
		return aiRepository.getRecentJoinAbleCamp(pid);
	}

	public AiPackCamp getCamp(String pid, long openTime) {
		return aiRepository.getCamp(pid, openTime);
	}

	public AiPackCampClass getRecentClass(String pid, long openTime) {
		return aiRepository.getRecentClass(pid, openTime);
	}

	public void createCampClass(String cid, String classNo, String pid, long openTime, String campName, int seq) {
		aiRepository.createCampClass(cid, classNo, pid, openTime, campName, seq);
	}

	public AiPackCampClass getClassInfo(String cid) {
		return aiRepository.getClassInfo(cid);
	}

}
