package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.UserCourseRepository;
import com.jz.jooq.media.tables.pojos.UserCoursePackWatch;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;

@Lazy
@Service
public class UserCourseService {

	@Autowired
	private UserCourseRepository userCourseRepository;

	public boolean existPackWatch(String uid, String brand, String pid) {
		return userCourseRepository.existPackWatch(uid, brand, pid);
	}

	public UserCoursePackWatch getPackWatch(String uid, String brand, String pid) {
		return userCourseRepository.getPackWatch(uid, brand, pid);
	}

	public void createPackWatch(String uid, String brand, String pid) {
		userCourseRepository.createPackWatch(uid, brand, pid);
	}

	public void updatePackWatchWid(String uid, String brand, String pid, String wid) {
		userCourseRepository.updatePackWatchWid(uid, brand, pid, wid);
	}

	public int cntMyPackPage(String uid, String brand) {
		return userCourseRepository.cntMyPackPage(uid, brand);
	}

	public List<String> getMyPackIdsPage(String uid, String brand, int start, int size) {
		return userCourseRepository.getMyPackIdsPage(uid, brand, start, size);
	}

	public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, String brand, Collection<String> wids) {
		return userCourseRepository.mutiGetUserCourseVideos(suid, brand, wids);
	}

	public UserCourseVideo getUserCourseVideo(String suid, String brand, String wid) {
		return userCourseRepository.getUserCourseVideo(suid, brand, wid);
	}

	public void updateCourseVideoPlayLength(String suid, String brand, String wid, int playLength, int maxPlayLength) {
		userCourseRepository.updateCourseVideoPlayLength(suid, brand, wid, playLength, maxPlayLength);
	}

	public void updateCourseVideoStatus(String suid, String brand, String wid, int status) {
		userCourseRepository.updateCourseVideoStatus(suid, brand, wid, status);
	}

	public Map<String, Integer> mutiCalFinishCnt(String suid, String brand, Collection<String> pids) {
		if (ArrayMapTools.isEmpty(pids)) {
			return null;
		}
		List<Map<String, Object>> list = userCourseRepository.mutiCalFinishCnt(suid, brand, pids);
		Map<String, Integer> map = Maps.newHashMap();
		list.forEach(m -> {
			map.put(MapUtils.getString(m, "pid"), MapUtils.getIntValue(m, "num"));
		});
		return map;
	}

	public Map<String, Integer> mutiCalFinishCntBySuids(Collection<String> suids, String brand, Collection<String> pids) {
		if (ArrayMapTools.isEmpty(pids) || ArrayMapTools.isEmpty(suids)) {
			return null;
		}
		List<Map<String, Object>> list = userCourseRepository.mutiCalFinishCntBySuids(suids, brand, pids);
		Map<String, Integer> map = Maps.newHashMap();
		list.forEach(m -> {
			map.put(MapUtils.getString(m, "pid"), MapUtils.getIntValue(m, "num"));
		});
		return map;
	}

}
