package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PhomePlaylist;

@Lazy
@Repository
public class PHomePlaylistRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PhomePlaylist PHPL = Tables.PHOME_PLAYLIST;

	public List<PhomePlaylist> findPlaylist(int start, int size) {
		return mediaCtx.selectFrom(PHPL).orderBy(PHPL.SEQ.asc()).limit(start, size).fetchInto(PhomePlaylist.class);
	}

	public int countPlaylist() {
		return mediaCtx.fetchCount(PHPL);
	}
}
