/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.AiMaterial;
import com.jz.jooq.media.tables.AiPackCamp;
import com.jz.jooq.media.tables.AiPackSerie;
import com.jz.jooq.media.tables.pojos.AiLesson;
import com.jz.jooq.media.tables.pojos.AiLessonSection;
import com.jz.jooq.media.tables.pojos.AiLessonSectionMaterial;
import com.jz.jooq.media.tables.pojos.AiPackCampClass;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;

@Repository
public class AiRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.AiLesson AL = Tables.AI_LESSON;
    private static final com.jz.jooq.media.tables.AiLessonSection ALS = Tables.AI_LESSON_SECTION;
    private static final com.jz.jooq.media.tables.AiLessonSectionMaterial ALSM = Tables.AI_LESSON_SECTION_MATERIAL;
    private static final AiMaterial AM = Tables.AI_MATERIAL;
    private static final AiPackSerie APS = Tables.AI_PACK_SERIE;
    private static final AiPackCamp APC = Tables.AI_PACK_CAMP;
    private static final com.jz.jooq.media.tables.AiPackCampClass APCC = Tables.AI_PACK_CAMP_CLASS;

    public AiLesson getLesson(String aid) {
        return (AiLesson)this.mediaCtx.selectFrom((Table)AL).where(new Condition[]{AiRepository.AL.AID.eq((Object)aid)}).fetchAnyInto(AiLesson.class);
    }

    public List<AiLesson> mutiGetOnlineLesson(Collection<String> aids) {
        return this.mediaCtx.selectFrom((Table)AL).where(new Condition[]{AiRepository.AL.AID.in(aids).and(AiRepository.AL.STATUS.eq((Object)1))}).fetchInto(AiLesson.class);
    }

    public List<AiLessonSection> getAiSections(String aid) {
        return this.mediaCtx.selectFrom((Table)ALS).where(new Condition[]{AiRepository.ALS.AID.eq((Object)aid)}).orderBy(AiRepository.ALS.SEQ.asc()).fetchInto(AiLessonSection.class);
    }

    public List<AiLessonSectionMaterial> getAiMaterials(String aid) {
        return this.mediaCtx.selectFrom((Table)ALSM).where(new Condition[]{AiRepository.ALSM.AID.eq((Object)aid)}).orderBy(AiRepository.ALSM.SEQ.asc()).fetchInto(AiLessonSectionMaterial.class);
    }

    public com.jz.jooq.media.tables.pojos.AiMaterial getMaterial(String id) {
        return (com.jz.jooq.media.tables.pojos.AiMaterial)this.mediaCtx.selectFrom((Table)AM).where(new Condition[]{AiRepository.AM.ID.eq((Object)id)}).fetchAnyInto(com.jz.jooq.media.tables.pojos.AiMaterial.class);
    }

    public List<com.jz.jooq.media.tables.pojos.AiMaterial> mutiGetOnlineMaterials(Collection<String> ids) {
        return this.mediaCtx.selectFrom((Table)AM).where(new Condition[]{AiRepository.AM.ID.in(ids).and(AiRepository.AM.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.media.tables.pojos.AiMaterial.class);
    }

    public List<com.jz.jooq.media.tables.pojos.AiPackSerie> getSeries(String pid) {
        return this.mediaCtx.selectFrom((Table)APS).orderBy(AiRepository.APS.SEQ.asc()).fetchInto(com.jz.jooq.media.tables.pojos.AiPackSerie.class);
    }

    public List<Long> getJoinAbleCampOpenTimes(String pid, long minOpenTime, int size) {
        return this.mediaCtx.select((SelectField)AiRepository.APC.OPEN_TIME).from((TableLike)APC).where(new Condition[]{AiRepository.APC.PID.eq((Object)pid).and(AiRepository.APC.OPEN_TIME.ge((Object)minOpenTime))}).orderBy(AiRepository.APC.OPEN_TIME.asc()).limit(size).fetchInto(Long.class);
    }

    public AiPackCampClass getRecentClass(String pid, long openTime) {
        return (AiPackCampClass)this.mediaCtx.selectFrom((Table)APCC).where(new Condition[]{AiRepository.APCC.PID.eq((Object)pid).and(AiRepository.APCC.OPEN_TIME.eq((Object)openTime))}).orderBy(AiRepository.APCC.SEQ.desc()).limit(1).fetchAnyInto(AiPackCampClass.class);
    }

    public void createCampClass(String cid, String classNo, String pid, long openTime, int seq) {
        this.mediaCtx.insertInto((Table)APCC, (Field)AiRepository.APCC.CID, (Field)AiRepository.APCC.CLASS_NO, (Field)AiRepository.APCC.PID, (Field)AiRepository.APCC.OPEN_TIME, (Field)AiRepository.APCC.SEQ, (Field)AiRepository.APCC.CREATE_TIME).values((Object)cid, (Object)classNo, (Object)pid, (Object)openTime, (Object)seq, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public AiPackCampClass getClassInfo(String cid) {
        return (AiPackCampClass)this.mediaCtx.selectFrom((Table)APCC).where(new Condition[]{AiRepository.APCC.CID.eq((Object)cid)}).fetchAnyInto(AiPackCampClass.class);
    }
}

