package com.jz.jar.media.enums;

import java.util.Arrays;
import java.util.List;

public enum UploadVideoStatus {
	
	/**************************************************************************/
	/**************** 用户上传的视频状态码,(code涉及到列表排序,谨慎调整) *************/
	/**************************************************************************/
	
	online("已上线", 1),
	offline("已下线(暂无可用地方)", 10),
	
	waiting("已上传,待转码", 20), 
	verifying("转码完成,审核中", 30),
	notPassed("审核未通过", 40),
	
	delete("用户删除", 98),
	adminDelete("管理员删除", 99),
	;

	private int code;
	
	UploadVideoStatus(String desc, int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
	
	private static List<UploadVideoStatus> validStatus;
	
	public static List<UploadVideoStatus> getValidStatus() {
		if (null != validStatus)
			return validStatus;
		validStatus = Arrays.asList(UploadVideoStatus.online, UploadVideoStatus.waiting, 
				UploadVideoStatus.verifying, UploadVideoStatus.notPassed);
		return validStatus;
	}
	
}
