package com.jz.jar.media.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @Title AuditStatus
 * @Package com.jz.jar.media.enums
 * @author tangjunfeng
 * @date 2019年3月6日 上午11:31:32
 * @version V1.0
 */
public enum AuditStatus {
	
	unchanged("未改变", -100), 
	finished("已完成", -50),
	reset("重置", 0), 
	
	online("已上线", 1),
	offline("已下线", 10),
	
	verify("审核中", 30),
	notPassed("审核未通过", 40),
	
	delete("用户删除", 98),
	adminDelete("管理员删除", 99),
	;
	
	private int code;
	
	AuditStatus(String desc, int code) {
		this.code = code;
	}

	public int getCode() {
		return code;
	}
	
	private static Map<Integer, AuditStatus> code2Status = Maps.newHashMap();
	
	public static AuditStatus ofCode(int code) {
		if (!code2Status.isEmpty())
			return code2Status.get(code);
		for (AuditStatus temp : AuditStatus.values()) {
			code2Status.put(temp.code, temp);
		}
		return code2Status.get(code);
	}
}
