/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Lists;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCourseAiPart;
import com.jz.jooq.media.tables.UserCoursePackWatch;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCourseRepository
extends MediaBaseRepository {
    private static final UserCoursePackWatch UCPW = Tables.USER_COURSE_PACK_WATCH;
    private static final com.jz.jooq.media.tables.UserCourseVideo UCV = Tables.USER_COURSE_VIDEO;
    private static final UserCourseAiPart UCAP = Tables.USER_COURSE_AI_PART;

    public boolean existPackWatch(String uid, String brand, String pid) {
        return this.mediaCtx.fetchExists((Table)UCPW, UserCourseRepository.UCPW.UID.eq((Object)uid).and(UserCourseRepository.UCPW.BRAND.eq((Object)brand)).and(UserCourseRepository.UCPW.PID.eq((Object)pid)));
    }

    public com.jz.jooq.media.tables.pojos.UserCoursePackWatch getPackWatch(String uid, String brand, String pid) {
        return (com.jz.jooq.media.tables.pojos.UserCoursePackWatch)this.mediaCtx.selectFrom((Table)UCPW).where(new Condition[]{UserCourseRepository.UCPW.UID.eq((Object)uid).and(UserCourseRepository.UCPW.BRAND.eq((Object)brand)).and(UserCourseRepository.UCPW.PID.eq((Object)pid))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.UserCoursePackWatch.class);
    }

    public void createPackWatch(String uid, String brand, String pid) {
        this.mediaCtx.insertInto((Table)UCPW, (Field)UserCourseRepository.UCPW.UID, (Field)UserCourseRepository.UCPW.BRAND, (Field)UserCourseRepository.UCPW.PID, (Field)UserCourseRepository.UCPW.CREATE_TIME).values((Object)uid, (Object)brand, (Object)pid, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void updatePackWatchWid(String uid, String brand, String pid, String wid) {
        this.mediaCtx.update((Table)UCPW).set((Field)UserCourseRepository.UCPW.WID, (Object)wid).where(new Condition[]{UserCourseRepository.UCPW.UID.eq((Object)uid).and(UserCourseRepository.UCPW.BRAND.eq((Object)brand)).and(UserCourseRepository.UCPW.PID.eq((Object)pid))}).execute();
    }

    public int cntMyPackPage(String uid, String brand) {
        return this.mediaCtx.fetchCount((Table)UCPW, UserCourseRepository.UCPW.UID.eq((Object)uid).and(UserCourseRepository.UCPW.BRAND.eq((Object)brand)));
    }

    public List<String> getMyPackIdsPage(String uid, String brand, int start, int size) {
        return this.mediaCtx.select((SelectField)UserCourseRepository.UCPW.PID).from((TableLike)UCPW).where(new Condition[]{UserCourseRepository.UCPW.UID.eq((Object)uid).and(UserCourseRepository.UCPW.BRAND.eq((Object)brand))}).orderBy(UserCourseRepository.UCPW.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, String brand, Collection<String> wids) {
        return this.mediaCtx.selectFrom((Table)UCV).where(new Condition[]{UserCourseRepository.UCV.SUID.eq((Object)suid).and(UserCourseRepository.UCV.BRAND.eq((Object)brand)).and(UserCourseRepository.UCV.WID.in(wids))}).fetchInto(UserCourseVideo.class);
    }

    public UserCourseVideo getUserCourseVideo(String suid, String brand, String wid) {
        return (UserCourseVideo)this.mediaCtx.selectFrom((Table)UCV).where(new Condition[]{UserCourseRepository.UCV.SUID.eq((Object)suid).and(UserCourseRepository.UCV.BRAND.eq((Object)brand)).and(UserCourseRepository.UCV.WID.eq((Object)wid))}).fetchAnyInto(UserCourseVideo.class);
    }

    public void updateCourseVideoPlayLength(String suid, String brand, String wid, int playLength, int maxPlayLength) {
        this.mediaCtx.insertInto((Table)UCV, (Field)UserCourseRepository.UCV.SUID, (Field)UserCourseRepository.UCV.BRAND, (Field)UserCourseRepository.UCV.WID, (Field)UserCourseRepository.UCV.PLAY_LENGTH, (Field)UserCourseRepository.UCV.MAX_PLAY_LENGTH, (Field)UserCourseRepository.UCV.STATUS, (Field)UserCourseRepository.UCV.CREATE_TIME).values((Object)suid, (Object)brand, (Object)wid, (Object)playLength, (Object)maxPlayLength, (Object)0, (Object)System.currentTimeMillis()).onDuplicateKeyUpdate().set((Field)UserCourseRepository.UCV.PLAY_LENGTH, (Object)playLength).set((Field)UserCourseRepository.UCV.MAX_PLAY_LENGTH, (Object)maxPlayLength).execute();
    }

    public void updateCourseVideoStatus(String suid, String brand, String wid, int status) {
        this.mediaCtx.insertInto((Table)UCV, (Field)UserCourseRepository.UCV.SUID, (Field)UserCourseRepository.UCV.BRAND, (Field)UserCourseRepository.UCV.WID, (Field)UserCourseRepository.UCV.STATUS, (Field)UserCourseRepository.UCV.CREATE_TIME).values((Object)suid, (Object)brand, (Object)wid, (Object)status, (Object)System.currentTimeMillis()).onDuplicateKeyUpdate().set((Field)UserCourseRepository.UCV.STATUS, (Object)status).execute();
    }

    public List<Map<String, Object>> mutiCalFinishCnt(String suid, String brand, Collection<String> pids) {
        String sql = "SELECT pid,COUNT(1) AS num FROM( SELECT wid,pid FROM `tomato_course_pack_video` WHERE pid IN(" + StringUtils.join(Collections.nCopies(pids.size(), "?"), (String)",") + ")" + " )t1 INNER JOIN(" + " SELECT `wid`" + " FROM `user_course_video`" + " WHERE suid=? AND brand=? AND `status` in(1,2)" + " )t2 ON t1.wid=t2.wid" + " GROUP BY pid";
        ArrayList args = Lists.newArrayList();
        args.addAll(pids);
        args.add(suid);
        args.add(brand);
        return this.mediaJdbcTemplate.queryForList(sql, args.toArray());
    }

    public void updateCourseAiPartStatus(String suid, String brand, String aid, String partId, int status) {
        this.mediaCtx.insertInto((Table)UCAP, (Field)UserCourseRepository.UCAP.SUID, (Field)UserCourseRepository.UCAP.BRAND, (Field)UserCourseRepository.UCAP.AID, (Field)UserCourseRepository.UCAP.PART_ID, (Field)UserCourseRepository.UCAP.STATUS, (Field)UserCourseRepository.UCAP.CREATE_TIME).values((Object)suid, (Object)brand, (Object)aid, (Object)partId, (Object)status, (Object)System.currentTimeMillis()).onDuplicateKeyUpdate().set((Field)UserCourseRepository.UCV.STATUS, (Object)status).execute();
    }

    public List<com.jz.jooq.media.tables.pojos.UserCourseAiPart> getUserCourseAiPartsByAid(String suid, String aid) {
        return this.mediaCtx.selectFrom((Table)UCAP).where(new Condition[]{UserCourseRepository.UCAP.SUID.eq((Object)suid).and(UserCourseRepository.UCAP.AID.eq((Object)aid))}).fetchInto(com.jz.jooq.media.tables.pojos.UserCourseAiPart.class);
    }
}

