package com.jz.jar.media.service;

import java.math.BigDecimal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCourseOrderRepository;
import com.jz.jooq.media.tables.pojos.UserCourseOrder;
import com.jz.jooq.media.tables.records.UserCourseOrderRecord;

@Lazy
@Service
public class UserCourseOrderService {

	@Autowired
	private UserCourseOrderRepository userCourseOrderRepository;

	public boolean checkPayed(String uid, String brand, String pid) {
		return userCourseOrderRepository.checkPayed(uid, brand, pid);
	}

	public UserCourseOrder getPayedOrder(String uid, String brand, String pid) {
		return userCourseOrderRepository.getPayedOrder(uid, brand, pid);
	}

	public void buyByCoinFinish(String orderId, String uid, String brand, String pid, Integer coin) {
		long current = System.currentTimeMillis();
		UserCourseOrderRecord record = new UserCourseOrderRecord();
		record.setOrderId(orderId);
		record.setUid(uid);
		record.setBrand(brand);
		record.setPid(pid);
		record.setType("coin"); // 付费类型 money金钱 coin蕃茄币
		record.setCoin(coin);
		record.setPayTime(current);
		record.setEndTime(current + 360 * 86400 * 1000l);
		record.setStatus(1); // 状态 0未缴费 1已缴费
		record.setCreateTime(current);
		userCourseOrderRepository.createOrder(record);
	}

	public void buyByMoneyCreate(String orderId, String uid, String brand, String pid, BigDecimal money) {
		long current = System.currentTimeMillis();
		UserCourseOrderRecord record = new UserCourseOrderRecord();
		record.setOrderId(orderId);
		record.setUid(uid);
		record.setBrand(brand);
		record.setPid(pid);
		record.setType("money"); // 付费类型 money金钱 coin蕃茄币
		record.setNeedPayMoney(money);
		record.setEndTime(current + 360 * 86400 * 1000l);
		record.setStatus(0); // 状态 0未缴费 1已缴费
		record.setCreateTime(current);
		userCourseOrderRepository.createOrder(record);
	}

	public UserCourseOrder getOrder(String orderId) {
		return userCourseOrderRepository.getOrder(orderId);
	}

	public void finishPay(String orderId, BigDecimal payMoney, String paymentMode, String onlineTradeId) {
		userCourseOrderRepository.finishPay(orderId, payMoney, paymentMode, onlineTradeId);
	}

}
