package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCollect;

@Lazy
@Repository
public class UserCollectRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCollect UC = Tables.USER_COLLECT;

	public void addCollect(String uid, String pid, BrandEnum brand) {
		mediaCtx.insertInto(UC, UC.UID, UC.PID, UC.BRANCH, UC.CREATE_TIME)
				.values(uid, pid, brand.name(), System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public List<UserCollect> getCollect(String uid, BrandEnum brand) {
		return mediaCtx.selectFrom(UC).where(UC.UID.eq(uid).and(UC.BRANCH.eq(brand.name())))
				.orderBy(UC.CREATE_TIME.desc()).fetchInto(UserCollect.class);
	}

	public int countCollect(String uid, BrandEnum brand) {
		return mediaCtx.fetchCount(UC, UC.UID.eq(uid).and(UC.BRANCH.eq(brand.name())));
	}

	public List<UserCollect> getCollect(String uid, BrandEnum brand, int start, int size) {
		return mediaCtx.selectFrom(UC).where(UC.UID.eq(uid).and(UC.BRANCH.eq(brand.name())))
				.orderBy(UC.CREATE_TIME.desc()).limit(start, size).fetchInto(UserCollect.class);
	}

	public boolean isCollect(String uid, String pid, BrandEnum brand) {
		return mediaCtx.fetchExists(UC, UC.UID.eq(uid).and(UC.PID.eq(pid)).and(UC.BRANCH.eq(brand.name())));
	}

	public void deleteCollect(String uid, String pid, BrandEnum brand) {
		mediaCtx.deleteFrom(UC).where(UC.UID.eq(uid).and(UC.PID.eq(pid)).and(UC.BRANCH.eq(brand.name()))).execute();
	}

	public List<String> getExistCollect(String uid, Collection<String> pids, BrandEnum brand) {
		return mediaCtx.select(UC.PID).from(UC)
				.where(UC.UID.eq(uid).and(UC.PID.in(pids)).and(UC.BRANCH.eq(brand.name()))).fetchInto(String.class);
	}
	
	public int countCollectForPlaylist(String pid) {
		return mediaCtx.fetchCount(UC, UC.PID.eq(pid));
	}
	
	public Map<String, Integer> countCollectForPlaylist(Collection<String> pids) {
		List<Map<String, Object>> maps = mediaCtx.select(UC.PID, DSL.count(UC.PID).as("ct")).from(UC)
				.where(UC.PID.in(pids)).groupBy(UC.PID).fetchMaps();
		if (ArrayMapTools.isEmpty(maps))
			return Maps.newHashMap();
		Map<String, Integer> pid2Cnt = Maps.newHashMap();
		maps.forEach(it -> {
			if (ArrayMapTools.isEmpty(it) || !ArrayMapTools.containsKeys(it, "pid", "ct"))
				return;
			pid2Cnt.put(MapUtils.getString(it, "pid"), MapUtils.getInteger(it, "ct"));
		});
		return pid2Cnt;
	}
}
