package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.DbField;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoCoursePackVideo;

@Lazy
@Repository
public class TomatoCoursePackRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.TomatoCoursePack TCP = Tables.TOMATO_COURSE_PACK;
	private static final com.jz.jooq.media.tables.TomatoCoursePackVideo TCPV = Tables.TOMATO_COURSE_PACK_VIDEO;

	public TomatoCoursePack getOnlinePack(String pid, String brand) {
		return mediaCtx.selectFrom(TCP)
				.where(TCP.PID.eq(pid).and(TCP.BRAND.eq(brand)).and(TCP.STATUS.eq(DbField.online.name())))
				.fetchAnyInto(TomatoCoursePack.class);
	}

	public TomatoCoursePack getOnlinePack(String pid) {
		return mediaCtx.selectFrom(TCP).where(TCP.PID.eq(pid).and(TCP.STATUS.eq(DbField.online.name())))
				.fetchAnyInto(TomatoCoursePack.class);
	}

	public List<TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids, String brand) {
		return mediaCtx.selectFrom(TCP)
				.where(TCP.PID.in(pids).and(TCP.BRAND.eq(brand)).and(TCP.STATUS.eq(DbField.online.name())))
				.fetchInto(TomatoCoursePack.class);
	}

	public List<TomatoCoursePackVideo> getPackVideos(String pid) {
		return mediaCtx.selectFrom(TCPV).where(TCPV.PID.eq(pid)).orderBy(TCPV.SEQ.asc())
				.fetchInto(TomatoCoursePackVideo.class);
	}

	public void increStudyCnt(String pid, int num) {
		mediaCtx.update(TCP).set(TCP.STUDY_CNT, TCP.STUDY_CNT.add(num)).where(TCP.PID.eq(pid)).execute();
	}

	public TomatoCoursePackVideo getPackVideo(String wid, String pid) {
		return mediaCtx.selectFrom(TCPV).where(TCPV.WID.eq(wid).and(TCPV.PID.eq(pid)))
				.fetchAnyInto(TomatoCoursePackVideo.class);
	}

}
