/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserRecomAudition;
import com.jz.jooq.media.tables.pojos.UserRecomContract;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserRecomRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.UserRecomAudition URA = Tables.USER_RECOM_AUDITION;
    private static final com.jz.jooq.media.tables.UserRecomContract URC = Tables.USER_RECOM_CONTRACT;

    public void createAudition(String puid, String suid, String schoolId, String sourcePuid, int num) {
        this.mediaCtx.insertInto((Table)URA, (Field)UserRecomRepository.URA.PUID, (Field)UserRecomRepository.URA.SUID, (Field)UserRecomRepository.URA.SCHOOL_ID, (Field)UserRecomRepository.URA.SOURCE_PUID, (Field)UserRecomRepository.URA.NUM, (Field)UserRecomRepository.URA.CREATED).values((Object)puid, (Object)suid, (Object)schoolId, (Object)sourcePuid, (Object)num, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public UserRecomAudition getAudition(String puid) {
        return (UserRecomAudition)this.mediaCtx.selectFrom((Table)URA).where(new Condition[]{UserRecomRepository.URA.PUID.eq((Object)puid)}).fetchAnyInto(UserRecomAudition.class);
    }

    public int cntAuditionBySourcePuid(String sourcePuid) {
        return this.mediaCtx.fetchCount((Table)URA, UserRecomRepository.URA.SOURCE_PUID.eq((Object)sourcePuid));
    }

    public List<UserRecomAudition> getAuditionBySourcePuid(String sourcePuid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)URA).where(new Condition[]{UserRecomRepository.URA.SOURCE_PUID.eq((Object)sourcePuid)}).orderBy(UserRecomRepository.URA.CREATED.desc()).limit(start, size).fetchInto(UserRecomAudition.class);
    }

    public void createContract(String contractId, String puid, String schoolId, String childName, String sourcePuid, int num) {
        this.mediaCtx.insertInto((Table)URC, (Field)UserRecomRepository.URC.CONTRACT_ID, (Field)UserRecomRepository.URC.PUID, (Field)UserRecomRepository.URC.SCHOOL_ID, (Field)UserRecomRepository.URC.CHILD_NAME, (Field)UserRecomRepository.URC.SOURCE_PUID, (Field)UserRecomRepository.URC.NUM, (Field)UserRecomRepository.URC.CREATED).values((Object)contractId, (Object)puid, (Object)schoolId, (Object)childName, (Object)sourcePuid, (Object)num, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public UserRecomContract getContract(String contractId) {
        return (UserRecomContract)this.mediaCtx.selectFrom((Table)URC).where(new Condition[]{UserRecomRepository.URC.CONTRACT_ID.eq((Object)contractId)}).fetchAnyInto(UserRecomContract.class);
    }

    public int cntContractBySourcePuid(String sourcePuid) {
        return this.mediaCtx.fetchCount((Table)URC, UserRecomRepository.URC.SOURCE_PUID.eq((Object)sourcePuid));
    }

    public List<UserRecomContract> getContractBySourcePuid(String sourcePuid, int start, int size) {
        return this.mediaCtx.selectFrom((Table)URC).where(new Condition[]{UserRecomRepository.URC.SOURCE_PUID.eq((Object)sourcePuid)}).orderBy(UserRecomRepository.URC.CREATED.desc()).limit(start, size).fetchInto(UserRecomContract.class);
    }
}

