package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.PostConstruct;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.media.repository.UserCoinTaskRepository;
import com.jz.jar.media.service.UserCoinService;
import com.jz.jooq.media.tables.pojos.UserCoinTaskDay;
import com.jz.jooq.media.tables.pojos.UserCoinTaskSetting;

/**
 * @author 连杰
 */
@Lazy
@Service
@EnableScheduling
public class UserCoinTaskService {

	private static final Logger logger = LoggerFactory.getLogger(UserCoinTaskService.class);

	@Autowired
	private UserCoinTaskRepository userCoinTaskRepository;
	@Autowired
	private UserCoinService userCoinService;

	public static Map<String, UserCoinTaskSetting> taskSettingMap = Maps.newHashMap();

	@PostConstruct
	@Scheduled(cron = "0 */5 * * * ?")
	public void cacheTask() {
		try {
			Map<String, UserCoinTaskSetting> taskSettingMapTemp = userCoinTaskRepository.listSettings().stream()
					.collect(Collectors.toMap(t -> t.getId(), t -> t));
			taskSettingMap = taskSettingMapTemp;
			logger.info("taskSettingMap.size:" + taskSettingMap.size());
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	public Integer dealTask(String uid, String taskId) {
		UserCoinTaskSetting task = taskSettingMap.get(taskId);
		if (task == null || task.getNum() <= 0) {
			return null;
		}
		if (task.getType() == 1) { // 任务只做一次,以后可以扩展任务类型
			if (userCoinTaskRepository.isExistTaskRecord(uid, taskId)) {
				return null;
			}
			userCoinTaskRepository.createTaskRecord(uid, taskId, task.getNum());
			userCoinService.updateUserCoin(uid, task.getNum(), task.getName());
			return task.getNum();
		} else if (task.getType() == 2) {
			userCoinService.updateUserCoin(uid, task.getNum(), task.getName());
			return task.getNum();
		}
		return null;
	}

	public UserCoinTaskSetting getTask(String taskId) {
		return taskSettingMap.get(taskId);
	}

	public List<String> mutiGetOnceTaskRecord(String uid, Collection<String> taskIds) {
		return userCoinTaskRepository.mutiGetOnceTaskRecord(uid, taskIds);
	}

	public void createTaskDay(String uid, String type, String date, Integer num, Integer taskDays) {
		userCoinTaskRepository.createTaskDay(uid, type, date, num, taskDays);
	}

	public UserCoinTaskDay getTaskDay(String uid, String type, String date) {
		return userCoinTaskRepository.getTaskDay(uid, type, date);
	}

	public List<UserCoinTaskDay> getRecentTaskDay(String uid, String type, String minDate) {
		return userCoinTaskRepository.getRecentTaskDay(uid, type, minDate);
	}

	public List<UserCoinTaskDay> mutiGetTaskDay(String uid, List<Pair<String, String>> typeDatePairs) {
		return userCoinTaskRepository.mutiGetTaskDay(uid, typeDatePairs);
	}
}
