package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserRecomAudition;
import com.jz.jooq.media.tables.pojos.UserRecomContract;

@Lazy
@Repository
public class UserRecomRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserRecomAudition URA = Tables.USER_RECOM_AUDITION;
	private static final com.jz.jooq.media.tables.UserRecomContract URC = Tables.USER_RECOM_CONTRACT;

	public void createAudition(String puid, String suid, String schoolId, String sourcePuid, int num) {
		mediaCtx.insertInto(URA, URA.PUID, URA.SUID, URA.SCHOOL_ID, URA.SOURCE_PUID, URA.NUM, URA.CREATED)
				.values(puid, suid, schoolId, sourcePuid, num, System.currentTimeMillis()).onDuplicateKeyIgnore()
				.execute();
	}

	public UserRecomAudition getAudition(String puid) {
		return mediaCtx.selectFrom(URA).where(URA.PUID.eq(puid)).fetchAnyInto(UserRecomAudition.class);
	}

	public int cntAuditionBySourcePuid(String sourcePuid) {
		return mediaCtx.fetchCount(URA, URA.SOURCE_PUID.eq(sourcePuid));
	}

	public List<UserRecomAudition> getAuditionBySourcePuid(String sourcePuid, int start, int size) {
		return mediaCtx.selectFrom(URA).where(URA.SOURCE_PUID.eq(sourcePuid)).orderBy(URA.CREATED.desc())
				.limit(start, size).fetchInto(UserRecomAudition.class);
	}

	public void createContract(String contractId, String puid, String schoolId, String childName, String sourcePuid,
			int num) {
		mediaCtx.insertInto(URC, URC.CONTRACT_ID, URC.PUID, URC.SCHOOL_ID, URC.CHILD_NAME, URC.SOURCE_PUID, URC.NUM,
				URC.CREATED).values(contractId, puid, schoolId, childName, sourcePuid, num, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public UserRecomContract getContract(String contractId) {
		return mediaCtx.selectFrom(URC).where(URC.CONTRACT_ID.eq(contractId)).fetchAnyInto(UserRecomContract.class);
	}

	public int cntContractBySourcePuid(String sourcePuid) {
		return mediaCtx.fetchCount(URC, URC.SOURCE_PUID.eq(sourcePuid));
	}

	public List<UserRecomContract> getContractBySourcePuid(String sourcePuid, int start, int size) {
		return mediaCtx.selectFrom(URC).where(URC.SOURCE_PUID.eq(sourcePuid)).orderBy(URC.CREATED.desc())
				.limit(start, size).fetchInto(UserRecomContract.class);
	}

}
