package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCoinTaskDay;
import com.jz.jooq.media.tables.pojos.UserCoinTaskSetting;

@Lazy
@Repository
public class UserCoinTaskRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoinTaskSetting UCTS = Tables.USER_COIN_TASK_SETTING;
	private static final com.jz.jooq.media.tables.UserCoinTaskRecord UCTR = Tables.USER_COIN_TASK_RECORD;
	private static final com.jz.jooq.media.tables.UserCoinTaskDay UCTD = Tables.USER_COIN_TASK_DAY;

	public List<UserCoinTaskSetting> listSettings() {
		return mediaCtx.selectFrom(UCTS).fetchInto(UserCoinTaskSetting.class);
	}

	public boolean isExistTaskRecord(String uid, String taskId) {
		return mediaCtx.fetchExists(UCTR, UCTR.UID.eq(uid).and(UCTR.TASK_ID.eq(taskId)));
	}

	public List<String> mutiGetOnceTaskRecord(String uid, Collection<String> taskIds) {
		return mediaCtx.select(UCTR.TASK_ID).from(UCTR).where(UCTR.UID.eq(uid).and(UCTR.TASK_ID.in(taskIds)))
				.fetchInto(String.class);
	}

	public void createTaskRecord(String uid, String taskId, Integer num) {
		mediaCtx.insertInto(UCTR, UCTR.UID, UCTR.TASK_ID, UCTR.NUM, UCTR.CREATED)
				.values(uid, taskId, num, System.currentTimeMillis()).execute();
	}

	public void createTaskDay(String uid, String type, String date, Integer num, Integer taskDays) {
		mediaCtx.insertInto(UCTD, UCTD.UID, UCTD.TYPE, UCTD.DATE, UCTR.NUM, UCTD.TASK_DAYS, UCTR.CREATED)
				.values(uid, type, date, num, taskDays, System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
	}

	public UserCoinTaskDay getTaskDay(String uid, String type, String date) {
		return mediaCtx.selectFrom(UCTD).where(UCTD.UID.eq(uid).and(UCTD.TYPE.eq(type)).and(UCTD.DATE.eq(date)))
				.fetchAnyInto(UserCoinTaskDay.class);
	}

	public List<UserCoinTaskDay> getRecentTaskDay(String uid, String type, String minDate) {
		return mediaCtx.selectFrom(UCTD).where(UCTD.UID.eq(uid).and(UCTD.TYPE.eq(type)).and(UCTD.DATE.ge(minDate)))
				.fetchInto(UserCoinTaskDay.class);
	}

	public List<UserCoinTaskDay> mutiGetTaskDay(String uid, List<Pair<String, String>> typeDatePairs) {
		List<Condition> conditions = Lists.newArrayList();
		for (Pair<String, String> p : typeDatePairs) {
			conditions.add(UCTD.TYPE.eq(p.getLeft()).and(UCTD.DATE.eq(p.getRight())));
		}
		return mediaCtx.selectFrom(UCTD).where(UCTD.UID.eq(uid).and(DSL.or(conditions)))
				.fetchInto(UserCoinTaskDay.class);
	}
}
