/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.UserCoin;
import com.jz.jooq.media.tables.UserCoinChange;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserCoinRepository
extends MediaBaseRepository {
    private static final UserCoin UC = Tables.USER_COIN;
    private static final UserCoinChange UCC = Tables.USER_COIN_CHANGE;

    public int getUserCurrentCoin(String uid) {
        Integer coin = (Integer)this.mediaCtx.select((SelectField)UserCoinRepository.UC.COIN).from((TableLike)UC).where(new Condition[]{UserCoinRepository.UC.UID.eq((Object)uid)}).fetchAnyInto(Integer.class);
        return coin != null && coin > 0 ? coin : 0;
    }

    public void updateUserCoin(String uid, int num) {
        this.mediaCtx.insertInto((Table)UC, (Field)UserCoinRepository.UC.UID, (Field)UserCoinRepository.UC.COIN).values((Object)uid, (Object)num).onDuplicateKeyUpdate().set((Field)UserCoinRepository.UC.COIN, UserCoinRepository.UC.COIN.add((Number)num)).execute();
    }

    public void saveCoinChange(String uid, int num, String remark) {
        this.mediaCtx.insertInto((Table)UCC, (Field)UserCoinRepository.UCC.UID, (Field)UserCoinRepository.UCC.NUM, (Field)UserCoinRepository.UCC.REMARK, (Field)UserCoinRepository.UCC.CREATE_TIME).values((Object)uid, (Object)num, (Object)remark, (Object)System.currentTimeMillis()).execute();
    }

    public int cntChangeRecords(String uid, Integer type) {
        return this.mediaCtx.fetchCount((Table)UCC, this.genWhere(uid, type));
    }

    public List<com.jz.jooq.media.tables.pojos.UserCoinChange> getChangeRecords(String uid, Integer type, int start, int size) {
        return this.mediaCtx.select((SelectField)UserCoinRepository.UCC.NUM, (SelectField)UserCoinRepository.UCC.REMARK, (SelectField)UserCoinRepository.UCC.CREATE_TIME).from((TableLike)UCC).where(new Condition[]{this.genWhere(uid, type)}).orderBy(UserCoinRepository.UCC.CREATE_TIME.desc()).limit(start, size).fetchInto(com.jz.jooq.media.tables.pojos.UserCoinChange.class);
    }

    private Condition genWhere(String uid, Integer type) {
        Condition c = UserCoinRepository.UCC.UID.eq((Object)uid);
        if (type != null) {
            c = type == 1 ? c.and(UserCoinRepository.UCC.NUM.gt((Object)0)) : c.and(UserCoinRepository.UCC.NUM.lt((Object)0));
        }
        return c;
    }
}

