package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoTagRepository;
import com.jz.jooq.media.tables.pojos.TomatoTagCoursePlaylist;
import com.jz.jooq.media.tables.pojos.TomatoTagInfo;

@Lazy
@Service
public class TomatoTagService {

	@Autowired
	private TomatoTagRepository tomatoTagRepository;

	public List<TomatoTagInfo> listTags() {
		return tomatoTagRepository.listTags();
	}

	public TomatoTagInfo getTag(String tid) {
		return tomatoTagRepository.getTag(tid);
	}

	public List<TomatoTagInfo> mutiGetTags(Collection<String> tids) {
		return tomatoTagRepository.mutiGetTags(tids);
	}

	public int cntOnlineOnSalePCsPage(String tid) {
		return tomatoTagRepository.cntOnlineOnSalePCsPage(tid);
	}

	public List<TomatoTagCoursePlaylist> getOnlineOnSalePCsPage(String tid, int start, int size) {
		return tomatoTagRepository.getOnlineOnSalePCsPage(tid, start, size);
	}
}
