/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.BaseConditionRepository;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksInfo;
import com.jz.jooq.media.tables.records.WorksInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksInfoRepository
extends MediaBaseRepository
implements BaseConditionRepository<WorksInfoRecord> {
    private static final WorksInfo WI = Tables.WORKS_INFO;

    private Condition getOpenOnlineCondition(BrandEnum brand) {
        return WorksInfoRepository.WI.BRAND.eq((Object)brand.name()).and(WorksInfoRepository.WI.STATUS.eq((Object)AuditStatus.online.getCode())).and(WorksInfoRepository.WI.IS_OPEN.ge((Object)1));
    }

    private Condition getOpenForTopicCondition(BrandEnum brand, String topicId) {
        return this.getOpenOnlineCondition(brand).and(WorksInfoRepository.WI.TID.eq((Object)topicId));
    }

    private Condition getRecommonCondition(BrandEnum brand) {
        return this.getOpenOnlineCondition(brand).and(WorksInfoRepository.WI.IS_RECOMM.eq((Object)1));
    }

    public boolean isExistWorksInfo(String id, BrandEnum brand) {
        return this.mediaCtx.fetchExists((Table)WI, WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name())));
    }

    public com.jz.jooq.media.tables.pojos.WorksInfo getWorksInfo(String id, BrandEnum brand) {
        return (com.jz.jooq.media.tables.pojos.WorksInfo)this.mediaCtx.selectFrom((Table)WI).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public com.jz.jooq.media.tables.pojos.WorksInfo getSimpleWorksInfo(String id, BrandEnum brand) {
        return (com.jz.jooq.media.tables.pojos.WorksInfo)this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID, (SelectField)WorksInfoRepository.WI.SCHOOL_ID, (SelectField)WorksInfoRepository.WI.LESSON_ID, (SelectField)WorksInfoRepository.WI.PUID, (SelectField)WorksInfoRepository.WI.SUID, (SelectField)WorksInfoRepository.WI.IS_OPEN, (SelectField)WorksInfoRepository.WI.IS_COLLECTIVE).from((TableLike)WI).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksInfo> findSimpleWorksInfo(Collection<String> artIds) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID, (SelectField)WorksInfoRepository.WI.PUID, (SelectField)WorksInfoRepository.WI.SUID, (SelectField)WorksInfoRepository.WI.TITLE, (SelectField)WorksInfoRepository.WI.PIC, (SelectField)WorksInfoRepository.WI.IS_OPEN, (SelectField)WorksInfoRepository.WI.IS_COLLECTIVE).from((TableLike)WI).where(new Condition[]{WorksInfoRepository.WI.ID.in(artIds)}).fetchInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public void updateOpenInfo(String id, BrandEnum brand, int isOpen, int addLikeCnt) {
        this.mediaCtx.update((Table)WI).set((Field)WorksInfoRepository.WI.IS_OPEN, (Object)isOpen).set((Field)WorksInfoRepository.WI.LIKE_CNT, WorksInfoRepository.WI.LIKE_CNT.add((Number)addLikeCnt)).set((Field)WorksInfoRepository.WI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).execute();
    }

    public int countOpenNewWorks(BrandEnum brand, Collection<String> workIds, long timestamp) {
        return this.mediaCtx.fetchCount((Table)WI, WorksInfoRepository.WI.ID.in(workIds).and(this.getOpenOnlineCondition(brand)).and(WorksInfoRepository.WI.CREATE_TIME.gt((Object)timestamp)));
    }

    public int countRecommonWorks(BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)WI, this.getRecommonCondition(brand));
    }

    public List<String> findRecommonWorksId(BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getRecommonCondition(brand)}).orderBy(WorksInfoRepository.WI.RECOMM_SEQ.desc(), WorksInfoRepository.WI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public int countOpenWorksForTopic(BrandEnum brand, String topicId) {
        return this.mediaCtx.fetchCount((Table)WI, this.getOpenForTopicCondition(brand, topicId));
    }

    public List<String> getOpenWorkIdsForTopic(BrandEnum brand, String tid, boolean isHot, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getOpenForTopicCondition(brand, tid)}).orderBy(new SortField[]{isHot ? WorksInfoRepository.WI.LIKE_CNT.desc() : WorksInfoRepository.WI.LAST_UPDATE.desc(), WorksInfoRepository.WI.CREATE_TIME.desc()}).limit(start, size).fetchInto(String.class);
    }

    public void addLikeCnt(String id, BrandEnum brand, int addLikeCnt) {
        this.mediaCtx.update((Table)WI).set((Field)WorksInfoRepository.WI.LIKE_CNT, WorksInfoRepository.WI.LIKE_CNT.add((Number)addLikeCnt)).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).execute();
    }

    private Condition getFilterOpenWorkCondition(BrandEnum brand, Collection<String> wids) {
        return WorksInfoRepository.WI.ID.in(wids).and(this.getOpenOnlineCondition(brand));
    }

    public List<String> filterOpenWorkIds(BrandEnum brand, Collection<String> wids, boolean isHot, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getFilterOpenWorkCondition(brand, wids)}).orderBy(new SortField[]{isHot ? WorksInfoRepository.WI.LIKE_CNT.desc() : WorksInfoRepository.WI.LAST_UPDATE.desc(), WorksInfoRepository.WI.CREATE_TIME.desc()}).limit(start, size).fetchInto(String.class);
    }

    public int countFilterOpenWorkIds(BrandEnum brand, Collection<String> wids) {
        return this.mediaCtx.fetchCount((Table)WI, this.getFilterOpenWorkCondition(brand, wids));
    }

    public com.jz.jooq.media.tables.pojos.WorksInfo getWorksInfo(String schoolId, String lessonId, String suid) {
        return (com.jz.jooq.media.tables.pojos.WorksInfo)this.mediaCtx.selectFrom((Table)WI).where(new Condition[]{WorksInfoRepository.WI.SCHOOL_ID.eq((Object)schoolId).and(WorksInfoRepository.WI.LESSON_ID.eq((Object)lessonId)).and(WorksInfoRepository.WI.SUID.eq((Object)suid))}).orderBy(WorksInfoRepository.WI.STATUS.asc()).limit(1).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public void createWorkInfo(String id, String brandId, String schoolId, String lessonId, String puid, String suid, String title, String appraise, String pic, String pictures, String audio, Integer audioDuration, String wid, String material, String tid, int isOpen, int status, String operator, int isCollective, int selfUpload) {
        long current = System.currentTimeMillis();
        this.mediaCtx.insertInto((Table)WI, (Field)WorksInfoRepository.WI.ID, (Field)WorksInfoRepository.WI.BRAND, (Field)WorksInfoRepository.WI.SCHOOL_ID, (Field)WorksInfoRepository.WI.LESSON_ID, (Field)WorksInfoRepository.WI.PUID, (Field)WorksInfoRepository.WI.SUID, (Field)WorksInfoRepository.WI.TITLE, (Field)WorksInfoRepository.WI.APPRAISE, (Field)WorksInfoRepository.WI.PIC, (Field)WorksInfoRepository.WI.PICTURES, (Field)WorksInfoRepository.WI.AUDIO, (Field)WorksInfoRepository.WI.AUDIO_DURATION, (Field)WorksInfoRepository.WI.WID, (Field)WorksInfoRepository.WI.MATERIAL, (Field)WorksInfoRepository.WI.TID, (Field)WorksInfoRepository.WI.IS_OPEN, (Field)WorksInfoRepository.WI.STATUS, (Field)WorksInfoRepository.WI.LAST_UPDATE, (Field)WorksInfoRepository.WI.CREATE_TIME, (Field)WorksInfoRepository.WI.OPERATER, (Field)WorksInfoRepository.WI.IS_COLLECTIVE, (Field)WorksInfoRepository.WI.SELF_UPLOAD).values((Object)id, (Object)brandId, (Object)schoolId, (Object)lessonId, (Object)puid, (Object)suid, (Object)title, (Object)appraise, (Object)pic, (Object)pictures, (Object)audio, (Object)audioDuration, (Object)wid, (Object)material, (Object)tid, (Object)isOpen, (Object)status, (Object)current, (Object)current, (Object)operator, (Object)isCollective, (Object)selfUpload).onDuplicateKeyIgnore().execute();
    }

    public void updateWorkInfo(String id, String schoolId, String lessonId, String title, String appraise, String pic, String pictures, String audio, Integer audioDuration, String wid, int status, String rejectReason) {
        this.mediaCtx.update((Table)WI).set((Field)WorksInfoRepository.WI.TITLE, (Object)title).set((Field)WorksInfoRepository.WI.APPRAISE, (Object)appraise).set((Field)WorksInfoRepository.WI.PIC, (Object)pic).set((Field)WorksInfoRepository.WI.PICTURES, (Object)pictures).set((Field)WorksInfoRepository.WI.AUDIO, (Object)audio).set((Field)WorksInfoRepository.WI.AUDIO_DURATION, (Object)audioDuration).set((Field)WorksInfoRepository.WI.WID, (Object)wid).set((Field)WorksInfoRepository.WI.STATUS, (Object)status).set((Field)WorksInfoRepository.WI.REJECT_REASON, (Object)rejectReason).set((Field)WorksInfoRepository.WI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.SCHOOL_ID.eq((Object)schoolId)).and(WorksInfoRepository.WI.LESSON_ID.eq((Object)lessonId))}).execute();
    }
}

