package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserCourseRepository;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;

@Lazy
@Service
public class UserCourseService {

	@Autowired
	private UserCourseRepository userCourseRepository;

	public boolean existPackWatch(String uid, String pid) {
		return userCourseRepository.existPackWatch(uid, pid);
	}

	public void createPackWatch(String uid, String pid) {
		userCourseRepository.createPackWatch(uid, pid);
	}

	public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, Collection<String> wids) {
		return userCourseRepository.mutiGetUserCourseVideos(suid, wids);
	}

	public UserCourseVideo getUserCourseVideo(String suid, String wid) {
		return userCourseRepository.getUserCourseVideo(suid, wid);
	}

	public void updateCourseVideoPlayLength(String suid, String wid, int playLength, int maxPlayLength) {
		userCourseRepository.updateCourseVideoPlayLength(suid, wid, playLength, maxPlayLength);
	}

	public void updateCourseVideoStatus(String suid, String wid, int status) {
		userCourseRepository.updateCourseVideoStatus(suid, wid, status);
	}

}
