package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UserCourseVideo;

@Lazy
@Repository
public class UserCourseRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UserCoursePackWatch UCPW = Tables.USER_COURSE_PACK_WATCH;
	private static final com.jz.jooq.media.tables.UserCourseVideo UCV = Tables.USER_COURSE_VIDEO;

	public boolean existPackWatch(String uid, String pid) {
		return mediaCtx.fetchExists(UCPW, UCPW.UID.eq(uid).and(UCPW.PID.eq(pid)));
	}

	public void createPackWatch(String uid, String pid) {
		mediaCtx.insertInto(UCPW, UCPW.UID, UCPW.PID, UCPW.CREATE_TIME).values(uid, pid, System.currentTimeMillis())
				.onDuplicateKeyIgnore().execute();
	}

	public List<UserCourseVideo> mutiGetUserCourseVideos(String suid, Collection<String> wids) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.WID.in(wids))).fetchInto(UserCourseVideo.class);
	}

	public UserCourseVideo getUserCourseVideo(String suid, String wid) {
		return mediaCtx.selectFrom(UCV).where(UCV.SUID.eq(suid).and(UCV.WID.eq(wid)))
				.fetchAnyInto(UserCourseVideo.class);
	}

	public void updateCourseVideoPlayLength(String suid, String wid, int playLength, int maxPlayLength) {
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.WID, UCV.PLAY_LENGTH, UCV.MAX_PLAY_LENGTH, UCV.STATUS, UCV.CREATE_TIME)
				.values(suid, wid, playLength, maxPlayLength, 0, System.currentTimeMillis()).onDuplicateKeyUpdate()
				.set(UCV.PLAY_LENGTH, playLength).set(UCV.MAX_PLAY_LENGTH, maxPlayLength).execute();
	}

	public void updateCourseVideoStatus(String suid, String wid, int status) {
		mediaCtx.insertInto(UCV, UCV.SUID, UCV.WID, UCV.STATUS, UCV.CREATE_TIME)
				.values(suid, wid, status, System.currentTimeMillis()).onDuplicateKeyUpdate().set(UCV.STATUS, status)
				.execute();
	}

}
