package com.jz.jar.media.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WechatSubUser;

@Lazy
@Repository
public class WechatSubUserRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WechatSubUser WU = Tables.WECHAT_SUB_USER;

	public WechatSubUser getWechatSubUser(String appid, String uid) {
		return mediaCtx.selectFrom(WU).where(WU.APPID.eq(appid).and(WU.UID.eq(uid))).fetchAnyInto(WechatSubUser.class);
	}

	public void addWechatSubUser(String appid, String uid, String phone, String code, String openid) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(WU, WU.APPID, WU.UID, WU.PHONE, WU.CODE, WU.OPENID, WU.CREATE_TIME, WU.LAST_UPDATE)
				.values(appid, uid, phone, code, openid, timeMillis, timeMillis).onDuplicateKeyIgnore().execute();
	}
}
