/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PlaylistRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.Playlist PL = Tables.PLAYLIST;

    public Playlist getOnlinePlaylist(String pid, BrandEnum brand) {
        return (Playlist)this.mediaCtx.selectFrom((Table)PL).where(new Condition[]{PlaylistRepository.PL.PID.eq((Object)pid).and(PlaylistRepository.PL.BRAND.eq((Object)brand.name())).and(PlaylistRepository.PL.STATUS.eq((Object)DbField.online.name()))}).fetchAnyInto(Playlist.class);
    }

    public List<Playlist> getOnlinePlaylist(Collection<String> pids, BrandEnum brand) {
        return this.mediaCtx.selectFrom((Table)PL).where(new Condition[]{PlaylistRepository.PL.PID.in(pids).and(PlaylistRepository.PL.BRAND.eq((Object)brand.name())).and(PlaylistRepository.PL.STATUS.eq((Object)DbField.online.name()))}).fetchInto(Playlist.class);
    }

    public List<Playlist> getPlaylist(int start, int size) {
        return this.mediaCtx.selectFrom((Table)PL).orderBy(PlaylistRepository.PL.LAST_UPDATE.desc()).limit(start, size).fetchInto(Playlist.class);
    }

    public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
        Result result = this.mediaCtx.select((SelectField)PlaylistRepository.PL.PID, (SelectField)PlaylistRepository.PL.VIDEO_CNT).from((TableLike)PL).where(new Condition[]{PlaylistRepository.PL.PID.in(pids)}).fetch();
        if (null == result || result.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap pid2VideoCount = Maps.newHashMap();
        result.forEach(it -> {
            Integer cfr_ignored_0 = (Integer)pid2VideoCount.put(it.value1(), it.value2());
        });
        return pid2VideoCount;
    }

    public String getWidForPlaylist(String pid) {
        return (String)this.mediaCtx.select((SelectField)PlaylistRepository.PL.WID).from((TableLike)PL).where(new Condition[]{PlaylistRepository.PL.PID.eq((Object)pid)}).fetchAnyInto(String.class);
    }

    public void addWatchCnt(String pid, BrandEnum brand, int cnt) {
        this.mediaCtx.update((Table)PL).set((Field)PlaylistRepository.PL.WATCH_CNT, PlaylistRepository.PL.WATCH_CNT.add((Number)cnt)).set((Field)PlaylistRepository.PL.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{PlaylistRepository.PL.PID.eq((Object)pid).and(PlaylistRepository.PL.BRAND.eq((Object)brand.name()))}).execute();
    }
}

