package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksAuthor;
import com.jz.jooq.media.tables.records.WorksAuthorRecord;

@Lazy
@Repository
public class WorksAuthorRepository extends MediaBaseRepository implements BaseConditionRepository<WorksAuthorRecord> {

	private static final com.jz.jooq.media.tables.WorksAuthor WA = Tables.WORKS_AUTHOR;

	private Condition getWorkIdCondition(BrandEnum brand, String workId) {
		return WA.BRAND.eq(brand.name()).and(WA.WORK_ID.eq(workId));
	}

	public List<String> getWorksAuthors(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.SUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchInto(String.class);
	}

	public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
		return mediaCtx.fetchExists(WA, getWorkIdCondition(brand, workId).and(WA.SUID.eq(suid)));
	}

	public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
		return mediaCtx.fetchExists(WA, getWorkIdCondition(brand, workId).and(WA.PUID.eq(puid)));
	}

	public String getWorksAuthor(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.SUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchAnyInto(String.class);
	}

	public String getWorksAuthorParent(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.PUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchAnyInto(String.class);
	}

	public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
		return mediaCtx.selectFrom(WA).where(WA.BRAND.eq(brand.name()).and(WA.WORK_ID.in(workIds)))
				.fetchInto(WorksAuthor.class);
	}

	/** 学员作品列表 */
	private Condition getStudentCondition(BrandEnum brand, String puid, String suid) {
		return WA.BRAND.eq(brand.name()).and(WA.PUID.eq(puid)).and(WA.SUID.eq(suid));
	}

	public int countStudentWorks(BrandEnum brand, String puid, String suid) {
		return mediaCtx.fetchCount(WA, getStudentCondition(brand, puid, suid));
	}

	public List<String> findStudentWorksId(BrandEnum brand, String puid, String suid, int start, int size) {
		return mediaCtx.select(WA.WORK_ID).from(WA).where(getStudentCondition(brand, puid, suid)).orderBy(WA.ID.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<String> findAllStudentWorksId(BrandEnum brand, String puid, String suid) {
		return mediaCtx.select(WA.WORK_ID).from(WA).where(getStudentCondition(brand, puid, suid))
				.fetchInto(String.class);
	}
	
	/** 获取存在作品的学校及课程 */
	public List<WorksAuthor> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
		Condition condition = getOrWhereCondition(WA.SCHOOL_ID, WA.LESSON_ID, school2LessonIds);
		return mediaCtx.select(WA.SCHOOL_ID, WA.LESSON_ID, WA.WORK_ID, WA.IS_COLLECTIVE).from(WA)
				.where(condition.and(WA.SUID.eq(suid))).fetchInto(WorksAuthor.class);
	}
}
