/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksAuthor;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksAuthorRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.WorksAuthor WA = Tables.WORKS_AUTHOR;

    private Condition getWorkIdCondition(BrandEnum brand, String workId) {
        return WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.WORK_ID.eq((Object)workId));
    }

    public List<String> getWorksAuthors(BrandEnum brand, String workId) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchInto(String.class);
    }

    public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
        return this.mediaCtx.fetchExists((Table)WA, this.getWorkIdCondition(brand, workId).and(WorksAuthorRepository.WA.SUID.eq((Object)suid)));
    }

    public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
        return this.mediaCtx.fetchExists((Table)WA, this.getWorkIdCondition(brand, workId).and(WorksAuthorRepository.WA.PUID.eq((Object)puid)));
    }

    public String getWorksAuthor(BrandEnum brand, String workId) {
        return (String)this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.SUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchAnyInto(String.class);
    }

    public String getWorksAuthorParent(BrandEnum brand, String workId) {
        return (String)this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.PUID).from((TableLike)WA).where(new Condition[]{this.getWorkIdCondition(brand, workId)}).fetchAnyInto(String.class);
    }

    public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
        return this.mediaCtx.selectFrom((Table)WA).where(new Condition[]{WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.WORK_ID.in(workIds))}).fetchInto(WorksAuthor.class);
    }

    private Condition getStudentCondition(BrandEnum brand, String puid, String suid) {
        return WorksAuthorRepository.WA.BRAND.eq((Object)brand.name()).and(WorksAuthorRepository.WA.PUID.eq((Object)puid)).and(WorksAuthorRepository.WA.SUID.eq((Object)suid));
    }

    public int countStudentWorks(BrandEnum brand, String puid, String suid) {
        return this.mediaCtx.fetchCount((Table)WA, this.getStudentCondition(brand, puid, suid));
    }

    public List<String> findStudentWorksId(BrandEnum brand, String puid, String suid, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.getStudentCondition(brand, puid, suid)}).orderBy(WorksAuthorRepository.WA.ID.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> findAllStudentWorksId(BrandEnum brand, String puid, String suid) {
        return this.mediaCtx.select((SelectField)WorksAuthorRepository.WA.WORK_ID).from((TableLike)WA).where(new Condition[]{this.getStudentCondition(brand, puid, suid)}).fetchInto(String.class);
    }
}

