package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.WorksAuthor;

@Lazy
@Repository
public class WorksAuthorRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.WorksAuthor WA = Tables.WORKS_AUTHOR;

	private Condition getWorkIdCondition(BrandEnum brand, String workId) {
		return WA.BRAND.eq(brand.name()).and(WA.WORK_ID.eq(workId));
	}

	public List<String> getWorksAuthors(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.SUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchInto(String.class);
	}

	public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
		return mediaCtx.fetchExists(WA, getWorkIdCondition(brand, workId).and(WA.SUID.eq(suid)));
	}

	public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
		return mediaCtx.fetchExists(WA, getWorkIdCondition(brand, workId).and(WA.PUID.eq(puid)));
	}

	public String getWorksAuthor(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.SUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchAnyInto(String.class);
	}

	public String getWorksAuthorParent(BrandEnum brand, String workId) {
		return mediaCtx.select(WA.PUID).from(WA).where(getWorkIdCondition(brand, workId)).fetchAnyInto(String.class);
	}

	public List<WorksAuthor> findWorkAuthor(BrandEnum brand, Collection<String> workIds) {
		return mediaCtx.selectFrom(WA).where(WA.BRAND.eq(brand.name()).and(WA.WORK_ID.in(workIds)))
				.fetchInto(WorksAuthor.class);
	}
}
