/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.BaseConditionRepository;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksInfo;
import com.jz.jooq.media.tables.records.WorksInfoRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksInfoRepository
extends MediaBaseRepository
implements BaseConditionRepository<WorksInfoRecord> {
    private static final WorksInfo WI = Tables.WORKS_INFO;

    private Condition getOpenOnlineCondition(BrandEnum brand) {
        return WorksInfoRepository.WI.BRAND.eq((Object)brand.name()).and(WorksInfoRepository.WI.STATUS.eq((Object)AuditStatus.online.getCode())).and(WorksInfoRepository.WI.IS_OPEN.ge((Object)1));
    }

    private Condition getOpenOnlineForPuidCondition(BrandEnum brand, Collection<String> uids) {
        return this.getOpenOnlineCondition(brand).and(WorksInfoRepository.WI.PUID.in(uids));
    }

    private Condition getOpenForTopicCondition(BrandEnum brand, String topicId) {
        return this.getOpenOnlineCondition(brand).and(WorksInfoRepository.WI.TID.eq((Object)topicId));
    }

    private Condition getRecommonCondition(BrandEnum brand) {
        return this.getOpenOnlineCondition(brand).and(WorksInfoRepository.WI.IS_RECOMM.eq((Object)1));
    }

    public boolean existWorksInfo(String id, BrandEnum brand) {
        return this.mediaCtx.fetchExists((Table)WI, WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name())));
    }

    public com.jz.jooq.media.tables.pojos.WorksInfo getWorksInfo(String id, BrandEnum brand) {
        return (com.jz.jooq.media.tables.pojos.WorksInfo)this.mediaCtx.selectFrom((Table)WI).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public com.jz.jooq.media.tables.pojos.WorksInfo getSimpleWorksInfo(String id, BrandEnum brand) {
        return (com.jz.jooq.media.tables.pojos.WorksInfo)this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID, (SelectField)WorksInfoRepository.WI.SCHOOL_ID, (SelectField)WorksInfoRepository.WI.LESSON_ID, (SelectField)WorksInfoRepository.WI.PUID, (SelectField)WorksInfoRepository.WI.SUID, (SelectField)WorksInfoRepository.WI.IS_OPEN, (SelectField)WorksInfoRepository.WI.IS_COLLECTIVE).from((TableLike)WI).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).fetchAnyInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksInfo> findSimpleWorksInfo(Collection<String> artIds) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID, (SelectField)WorksInfoRepository.WI.PUID, (SelectField)WorksInfoRepository.WI.SUID, (SelectField)WorksInfoRepository.WI.PIC, (SelectField)WorksInfoRepository.WI.IS_OPEN, (SelectField)WorksInfoRepository.WI.IS_COLLECTIVE).from((TableLike)WI).where(new Condition[]{WorksInfoRepository.WI.ID.in(artIds)}).fetchInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    public void updateOpenInfo(String id, BrandEnum brand, int isOpen, int addLikeCnt) {
        this.mediaCtx.update((Table)WI).set((Field)WorksInfoRepository.WI.IS_OPEN, (Object)isOpen).set((Field)WorksInfoRepository.WI.LIKE_CNT, WorksInfoRepository.WI.LIKE_CNT.add((Number)addLikeCnt)).set((Field)WorksInfoRepository.WI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).execute();
    }

    public int countOpenNewWorks(BrandEnum brand, Collection<String> uids, long timestamp) {
        return this.mediaCtx.fetchCount((Table)WI, this.getOpenOnlineForPuidCondition(brand, uids).and(WorksInfoRepository.WI.CREATE_TIME.gt((Object)timestamp)));
    }

    public int countOpenWorks(BrandEnum brand, Collection<String> uids) {
        return this.mediaCtx.fetchCount((Table)WI, this.getOpenOnlineForPuidCondition(brand, uids));
    }

    public List<String> findOpenWorksId(BrandEnum brand, Collection<String> uids, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getOpenOnlineForPuidCondition(brand, uids)}).orderBy(WorksInfoRepository.WI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public int countRecommonWorks(BrandEnum brand) {
        return this.mediaCtx.fetchCount((Table)WI, this.getRecommonCondition(brand));
    }

    public List<String> findRecommonWorksId(BrandEnum brand, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getRecommonCondition(brand)}).orderBy(WorksInfoRepository.WI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksInfo> findExistWorksInfo(Map<String, Collection<String>> school2LessonIds, String suid) {
        Condition condition = this.getOrWhereCondition(WorksInfoRepository.WI.SCHOOL_ID, WorksInfoRepository.WI.LESSON_ID, school2LessonIds);
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.SCHOOL_ID, (SelectField)WorksInfoRepository.WI.LESSON_ID, (SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{condition.and(WorksInfoRepository.WI.SUID.eq((Object)suid)).and(WorksInfoRepository.WI.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchInto(com.jz.jooq.media.tables.pojos.WorksInfo.class);
    }

    private Condition getStudentCondition(BrandEnum brand, String puid, String suid) {
        Condition condition = WorksInfoRepository.WI.BRAND.eq((Object)brand.name()).and(WorksInfoRepository.WI.PUID.eq((Object)puid)).and(WorksInfoRepository.WI.STATUS.eq((Object)AuditStatus.online.getCode()));
        if (StringTools.isNotEmpty((CharSequence)suid)) {
            return condition.and(WorksInfoRepository.WI.SUID.eq((Object)suid));
        }
        return condition;
    }

    public int countStudentWorks(BrandEnum brand, String puid, String suid) {
        return this.mediaCtx.fetchCount((Table)WI, this.getStudentCondition(brand, puid, suid));
    }

    public List<String> findStudentWorksId(BrandEnum brand, String puid, String suid, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getStudentCondition(brand, puid, suid)}).orderBy(WorksInfoRepository.WI.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> findAllStudentWorksId(BrandEnum brand, String puid, String suid) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getStudentCondition(brand, puid, suid)}).fetchInto(String.class);
    }

    public int countOpenWorksForTopic(BrandEnum brand, String topicId) {
        return this.mediaCtx.fetchCount((Table)WI, this.getOpenForTopicCondition(brand, topicId));
    }

    public List<String> getOpenWorkIdsForTopic(BrandEnum brand, String tid, boolean isHot, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getOpenForTopicCondition(brand, tid)}).orderBy(new SortField[]{isHot ? WorksInfoRepository.WI.LIKE_CNT.desc() : WorksInfoRepository.WI.LAST_UPDATE.desc()}).limit(start, size).fetchInto(String.class);
    }

    public void addLikeCnt(String id, BrandEnum brand, int addLikeCnt) {
        this.mediaCtx.update((Table)WI).set((Field)WorksInfoRepository.WI.LIKE_CNT, WorksInfoRepository.WI.LIKE_CNT.add((Number)addLikeCnt)).where(new Condition[]{WorksInfoRepository.WI.ID.eq((Object)id).and(WorksInfoRepository.WI.BRAND.eq((Object)brand.name()))}).execute();
    }

    private Condition getFilterOpenWorkCondition(BrandEnum brand, Collection<String> wids) {
        return WorksInfoRepository.WI.ID.in(wids).and(this.getOpenOnlineCondition(brand));
    }

    public List<String> filterOpenWorkIds(BrandEnum brand, Collection<String> wids, boolean isHot, int start, int size) {
        return this.mediaCtx.select((SelectField)WorksInfoRepository.WI.ID).from((TableLike)WI).where(new Condition[]{this.getFilterOpenWorkCondition(brand, wids)}).orderBy(new SortField[]{isHot ? WorksInfoRepository.WI.LIKE_CNT.desc() : WorksInfoRepository.WI.LAST_UPDATE.desc()}).limit(start, size).fetchInto(String.class);
    }

    public int countFilterOpenWorkIds(BrandEnum brand, Collection<String> wids) {
        return this.mediaCtx.fetchCount((Table)WI, this.getFilterOpenWorkCondition(brand, wids));
    }
}

