package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.repository.WorksAuthorRepository;

@Lazy
@Service
public class WorksAuthorService {

	@Autowired
	private WorksAuthorRepository worksAuthorRepository;

	public List<String> getWorksAuthors(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthors(brand, workId);
	}

	public boolean isWorksAuthor(BrandEnum brand, String workId, String suid) {
		return worksAuthorRepository.isWorksAuthor(brand, workId, suid);
	}

	public boolean isWorksAuthorParent(BrandEnum brand, String workId, String puid) {
		return worksAuthorRepository.isWorksAuthorParent(brand, workId, puid);
	}

	public String getWorksAuthor(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthor(brand, workId);
	}

	public String getWorksAuthorParent(BrandEnum brand, String workId) {
		return worksAuthorRepository.getWorksAuthorParent(brand, workId);
	}
}
